/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.api.entity.factions.IVillageFactionData;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class VampireVillageData
implements IVillageFactionData {
    private final ItemStack banner = VampireVillageData.createBanner();
    private List<CaptureEntityEntry> captureEntityEntries;

    public static ItemStack createBanner() {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196206_ev);
        CompoundNBT compoundNBT = itemStack.func_190925_c("BlockEntityTag");
        ListNBT listNBT = new BannerPattern.Builder().func_222477_a(BannerPattern.TRIANGLES_BOTTOM, DyeColor.RED).func_222477_a(BannerPattern.TRIANGLES_TOP, DyeColor.RED).func_222477_a(BannerPattern.BORDER, DyeColor.PURPLE).func_222477_a(BannerPattern.RHOMBUS_MIDDLE, DyeColor.RED).func_222477_a(BannerPattern.STRAIGHT_CROSS, DyeColor.RED).func_222477_a(BannerPattern.CIRCLE_MIDDLE, DyeColor.PURPLE).func_222476_a();
        compoundNBT.func_218657_a("Patterns", (INBT)listNBT);
        itemStack.func_242395_a(ItemStack.TooltipDisplayFlags.ADDITIONAL);
        itemStack.func_200302_a((ITextComponent)new TranslationTextComponent("block.minecraft.ominous_banner").func_240699_a_(TextFormatting.GOLD));
        return itemStack;
    }

    public static void vampireVillage(IFactionVillageBuilder builder) {
        builder.badOmenEffect(() -> (BadOmenEffect)ModEffects.BAD_OMEN_VAMPIRE.get()).captureEntities(() -> Lists.newArrayList((Object[])new CaptureEntityEntry[]{new CaptureEntityEntry((EntityType<? extends MobEntity>)((EntityType)ModEntities.VAMPIRE.get()), 10), new CaptureEntityEntry((EntityType<? extends MobEntity>)((EntityType)ModEntities.ADVANCED_VAMPIRE.get()), 2)})).factionVillagerProfession(() -> (VillagerProfession)ModVillage.VAMPIRE_EXPERT.get()).guardSuperClass(VampireBaseEntity.class).taskMaster(() -> (EntityType)ModEntities.TASK_MASTER_VAMPIRE.get()).banner(VampireVillageData::createBanner).totem(() -> (TotemTopBlock)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get(), () -> (TotemTopBlock)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE_CRAFTED.get());
    }

    @Override
    @Nonnull
    public ItemStack getBanner() {
        return this.banner.func_77946_l();
    }

    @Override
    public List<CaptureEntityEntry> getCaptureEntries() {
        if (this.captureEntityEntries == null) {
            this.captureEntityEntries = Lists.newArrayList((Object[])new CaptureEntityEntry[]{new CaptureEntityEntry((EntityType<? extends MobEntity>)((EntityType)ModEntities.VAMPIRE.get()), 10), new CaptureEntityEntry((EntityType<? extends MobEntity>)((EntityType)ModEntities.ADVANCED_VAMPIRE.get()), 2)});
        }
        return this.captureEntityEntries;
    }

    @Override
    @Nonnull
    public VillagerProfession getFactionVillageProfession() {
        return (VillagerProfession)ModVillage.VAMPIRE_EXPERT.get();
    }

    @Override
    @Nonnull
    public Class<? extends MobEntity> getGuardSuperClass() {
        return VampireBaseEntity.class;
    }

    @Override
    public EntityType<? extends ITaskMasterEntity> getTaskMasterEntity() {
        return (EntityType)ModEntities.TASK_MASTER_VAMPIRE.get();
    }

    @Override
    @Nonnull
    public Pair<Block, Block> getTotemTopBlock() {
        return Pair.of((Object)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get(), (Object)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE_CRAFTED.get());
    }

    @Override
    public boolean isBanner(@Nonnull ItemStack stack) {
        return ItemStack.func_77989_b((ItemStack)this.banner, (ItemStack)stack);
    }
}

