/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.biome;

import de.teamlapen.vampirism.blocks.CursedEarthBlock;
import de.teamlapen.vampirism.blocks.CursedGrass;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.world.biome.VampirismBiomeFeatures;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class VampireForestBiome {
    public static Biome createVampireForest(float depth, float scale) {
        return VampireForestBiome.createBiomeBuilder(depth, scale, VampireForestBiome.createMobInfoBuilder(), VampireForestBiome.createBiomeAmbienceBuilder()).func_242455_a();
    }

    public static Biome.Builder createBiomeBuilder(float depth, float scale, MobSpawnInfo.Builder spawnBuilder, BiomeAmbience.Builder ambienceBuilder) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(((CursedGrass)ModBlocks.CURSED_GRASS.get()).func_176223_P(), ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).func_176223_P(), ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).func_176223_P())));
        return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.FOREST).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.3f).func_205417_d(0.0f).func_235097_a_(ambienceBuilder.func_235238_a_()).func_242458_a(spawnBuilder.func_242577_b()).func_242457_a(builder.func_242508_a());
    }

    public static void addFeatures(BiomeLoadingEvent event) {
        if (event.getName().equals((Object)ModBiomes.VAMPIRE_FOREST.getId())) {
            BiomeGenerationSettingsBuilder builder = event.getGeneration();
            DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
            VampirismBiomeFeatures.addModdedWaterLake((BiomeGenerationSettings.Builder)builder);
            VampirismBiomeFeatures.addVampireFlower((BiomeGenerationSettings.Builder)builder);
            VampirismBiomeFeatures.addBushPatch((BiomeGenerationSettings.Builder)builder);
            DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)builder);
            VampirismBiomeFeatures.addUndergroundVariety((BiomeGenerationSettings.Builder)builder);
            DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
            DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
            VampirismBiomeFeatures.addDarkStoneSoftDisk((BiomeGenerationSettings.Builder)builder);
            VampirismBiomeFeatures.addVampireTrees((BiomeGenerationSettings.Builder)builder);
            VampirismBiomeFeatures.addWaterSprings((BiomeGenerationSettings.Builder)builder);
        }
    }

    public static MobSpawnInfo.Builder createMobInfoBuilder() {
        MobSpawnInfo.Builder builder = new MobSpawnInfo.Builder();
        builder.func_242572_a(0.25f);
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)ModEntities.VAMPIRE.get(), 35, 1, 3));
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)ModEntities.VAMPIRE_BARON.get(), ((Integer)VampirismConfig.COMMON.baronSpawnChance.get()).intValue(), 1, 1));
        builder.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners((EntityType)ModEntities.BLINDING_BAT.get(), 60, 2, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)ModEntities.DUMMY_CREATURE.get(), 80, 3, 6));
        return builder;
    }

    public static BiomeAmbience.Builder createBiomeAmbienceBuilder() {
        return new BiomeAmbience.Builder().func_235246_b_(6752023).func_235248_c_(6752023).func_235239_a_(0x171717).func_242539_d(0x131313).func_242540_e(0x101010).func_242541_f(0x101010).func_235243_a_(new MoodSoundAmbience(SoundEvents.field_232722_g_, 6000, 8, 2.0)).func_235242_a_(new SoundAdditionsAmbience(SoundEvents.field_232701_e_, 0.0111)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)SoundEvents.field_232762_ir_));
    }
}

