/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.treedecorator;

import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.blocks.CursedBarkBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFeatures;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;

public class TrunkCursedVineTreeDecorator
extends TreeDecorator {
    public static final TrunkCursedVineTreeDecorator INSTANCE = new TrunkCursedVineTreeDecorator();
    public static final Codec<TrunkCursedVineTreeDecorator> CODEC = Codec.unit(() -> INSTANCE);

    @Nonnull
    protected TreeDecoratorType<?> func_230380_a_() {
        return (TreeDecoratorType)ModFeatures.TRUNK_CURSED_VINE.get();
    }

    public void func_225576_a_(@Nonnull ISeedReader seedReader, @Nonnull Random random, List<BlockPos> posList, @Nonnull List<BlockPos> posList1, @Nonnull Set<BlockPos> posSet, @Nonnull MutableBoundingBox boundingBox) {
        posList.forEach(trunkPos -> {
            BlockState trunkState = seedReader.func_180495_p(trunkPos);
            List directions = Arrays.stream(Direction.values()).collect(Collectors.toList());
            Direction.Axis axis = Direction.Axis.Y;
            if (trunkState.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
                switch ((Direction.Axis)trunkState.func_177229_b((Property)BlockStateProperties.field_208148_A)) {
                    case X: {
                        directions.remove(Direction.WEST);
                        directions.remove(Direction.EAST);
                        axis = Direction.Axis.X;
                        break;
                    }
                    case Y: {
                        directions.remove(Direction.UP);
                        directions.remove(Direction.DOWN);
                        break;
                    }
                    case Z: {
                        directions.remove(Direction.NORTH);
                        directions.remove(Direction.SOUTH);
                        axis = Direction.Axis.Z;
                    }
                }
            }
            for (Direction direction : directions) {
                BlockPos blockpos = trunkPos.func_177972_a(direction);
                if (Feature.func_236297_b_((IWorldGenerationBaseReader)seedReader, (BlockPos)blockpos)) {
                    this.placeCursedVine((IWorldWriter)seedReader, blockpos, direction.func_176734_d(), direction.func_176734_d(), axis, posSet, boundingBox);
                }
                for (Direction direction1 : directions) {
                    BlockPos blockpos1;
                    if (direction == direction1.func_176734_d() || direction == direction1 || !Feature.func_236297_b_((IWorldGenerationBaseReader)seedReader, (BlockPos)(blockpos1 = blockpos.func_177972_a(direction1)))) continue;
                    this.placeCursedVine((IWorldWriter)seedReader, blockpos1, direction.func_176734_d(), direction1.func_176734_d(), axis, posSet, boundingBox);
                }
            }
        });
    }

    protected void placeCursedVine(IWorldWriter levelWriter, BlockPos pos, Direction mainDirection, Direction secondaryDirection, Direction.Axis axis, Set<BlockPos> blockPositions, MutableBoundingBox boundingBox) {
        this.func_227423_a_(levelWriter, pos, (BlockState)((BlockState)((BlockState)((CursedBarkBlock)ModBlocks.CURSED_BARK.get()).func_176223_P().func_206870_a((Property)CursedBarkBlock.FACING, (Comparable)mainDirection)).func_206870_a((Property)CursedBarkBlock.FACING2, (Comparable)secondaryDirection)).func_206870_a(CursedBarkBlock.AXIS, (Comparable)axis), blockPositions, boundingBox);
    }
}

