/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.gen.feature.template.AlwaysTrueTest;
import net.minecraft.world.gen.feature.template.PosRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleTest;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RandomBlockState
extends RuleEntry {
    public static final Codec<Pair<BlockState, Optional<CompoundNBT>>> PAIR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("state").forGetter(entry -> (BlockState)entry.getLeft()), (App)CompoundNBT.field_240597_a_.optionalFieldOf("output_nbt").forGetter(entry -> (Optional)entry.getValue())).apply((Applicative)instance, ImmutablePair::new));
    public static final Codec<RandomBlockState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.field_237127_c_.fieldOf("input_predicate").forGetter(getter -> getter.field_215214_a), (App)RuleTest.field_237127_c_.fieldOf("location_predicate").forGetter(entry -> entry.field_215215_b), (App)PAIR_CODEC.fieldOf("default_state").forGetter(entry -> Pair.of((Object)entry.field_215216_c, Optional.ofNullable(entry.field_215217_d))), (App)PAIR_CODEC.listOf().fieldOf("states").forGetter(entry -> Lists.newArrayList(entry.states))).apply((Applicative)instance, RandomBlockState::new));
    private static final Random RNG = new Random();
    private final List<Pair<BlockState, Optional<CompoundNBT>>> states;

    public RandomBlockState(RuleTest inputPredicate, RuleTest locationPredicate, BlockState defaultState, List<BlockState> outputStates) {
        this(inputPredicate, locationPredicate, (Pair<BlockState, Optional<CompoundNBT>>)Pair.of((Object)defaultState, Optional.empty()), outputStates.stream().map(state -> Pair.of((Object)state, Optional.empty())).collect(Collectors.toList()));
    }

    public RandomBlockState(RuleTest inputPredicate, RuleTest locationPredicate, Pair<BlockState, Optional<CompoundNBT>> defaultState, List<Pair<BlockState, Optional<CompoundNBT>>> states) {
        super(inputPredicate, locationPredicate, (PosRuleTest)AlwaysTrueTest.field_237100_b_, (BlockState)defaultState.getLeft(), (Optional)defaultState.getRight());
        this.states = states;
    }

    public Pair<BlockState, Optional<CompoundNBT>> getOutput() {
        if (!this.states.isEmpty()) {
            int type = RNG.nextInt(this.states.size());
            return this.states.get(type);
        }
        return Pair.of((Object)this.field_215216_c, Optional.ofNullable(this.field_215217_d));
    }
}

