/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.items.VampireBookItem;
import de.teamlapen.vampirism.util.VampireBookManager;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;

public class AddBookNbt
extends LootFunction {
    public static LootFunction.Builder<?> builder() {
        return AddBookNbt.func_215860_a(AddBookNbt::new);
    }

    public AddBookNbt(ILootCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public LootFunctionType func_230425_b_() {
        return ModLoot.add_book_nbt;
    }

    @Nonnull
    public ItemStack func_215859_a(@Nonnull ItemStack itemStack, LootContext lootContext) {
        Entity victim = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        Optional<Object> id = Optional.empty();
        if (victim instanceof AdvancedHunterEntity) {
            id = ((AdvancedHunterEntity)victim).getBookLootId();
        } else if (victim instanceof AdvancedVampireEntity) {
            id = ((AdvancedVampireEntity)victim).getBookLootId();
        }
        VampireBookManager.BookContext bookContext = id.map(VampireBookManager.getInstance()::getBookContextById).orElseGet(() -> VampireBookManager.getInstance().getRandomBook(lootContext.func_216032_b()));
        itemStack.func_77982_d(VampireBookItem.createTagFromContext(bookContext));
        return itemStack;
    }

    public static class Serializer
    extends LootFunction.Serializer<AddBookNbt> {
        @Nonnull
        public AddBookNbt deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext jsonDeserializationContext, @Nonnull ILootCondition[] iLootConditions) {
            return new AddBookNbt(iLootConditions);
        }
    }
}

