/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.core.ModLoot;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;

public class AdjustableLevelCondition
implements ILootCondition {
    private final int levelTest;
    private final LootContext.EntityTarget target;

    public static ILootCondition.IBuilder builder(int level, LootContext.EntityTarget target) {
        return () -> new AdjustableLevelCondition(level, target);
    }

    public AdjustableLevelCondition(int level, LootContext.EntityTarget targetIn) {
        this.levelTest = level;
        this.target = targetIn;
    }

    @Nonnull
    public LootConditionType func_230419_b_() {
        return ModLoot.adjustable_level;
    }

    public boolean test(LootContext lootContext) {
        Entity e = (Entity)lootContext.func_216031_c(this.target.func_216029_a());
        if (e instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)e).getLevel();
            if (this.levelTest != -1) {
                return this.levelTest == l;
            }
        }
        return false;
    }

    public static class Serializer
    implements ILootSerializer<AdjustableLevelCondition> {
        @Nonnull
        public AdjustableLevelCondition deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new AdjustableLevelCondition(json.has("level") ? JSONUtils.func_151203_m((JsonObject)json, (String)"level") : -1, (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }

        public void serialize(JsonObject json, AdjustableLevelCondition lootFunction, JsonSerializationContext context) {
            json.add("level", context.serialize((Object)lootFunction.levelTest));
            json.add("entity", context.serialize((Object)lootFunction.target));
        }
    }
}

