/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;

public class FactionCondition
implements ILootCondition {
    @Nonnull
    private final Type type;
    private final IPlayableFaction<? extends IFactionPlayer<?>> faction;
    private final int minLevel;
    private final int maxLevel;

    public FactionCondition(IPlayableFaction<? extends IFactionPlayer<?>> faction, int minLevel, int maxLevel) {
        this.type = Type.FACTION;
        this.faction = faction;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public FactionCondition(int minLevel, int maxLevel) {
        this.type = Type.ANY_FACTION;
        this.faction = null;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public FactionCondition() {
        this.type = Type.ANY_FACTION;
        this.faction = null;
        this.minLevel = 0;
        this.maxLevel = -1;
    }

    @Nonnull
    public LootConditionType func_230419_b_() {
        return ModLoot.faction;
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            switch (this.type) {
                case FACTION: {
                    if (this.faction == null) {
                        return false;
                    }
                    return VampirismAPI.getFactionPlayerHandler(player).filter(a -> a.isInFaction(this.faction)).filter(a -> a.getCurrentLevel() >= this.minLevel && (this.maxLevel == -1 || a.getCurrentLevel() <= this.maxLevel)).isPresent();
                }
                case NO_FACTION: {
                    return VampirismAPI.getFactionPlayerHandler(player).filter(p -> !p.getCurrentFactionPlayer().isPresent()).isPresent();
                }
                case ANY_FACTION: {
                    return VampirismAPI.getFactionPlayerHandler(player).filter(a -> a.getCurrentLevel() >= this.minLevel && (this.maxLevel == -1 || a.getCurrentLevel() <= this.maxLevel)).isPresent();
                }
            }
        }
        return false;
    }

    public static class Serializer
    implements ILootSerializer<FactionCondition> {
        public void serialize(@Nonnull JsonObject json, @Nonnull FactionCondition condition, @Nonnull JsonSerializationContext context) {
            json.addProperty("type", condition.type.name());
            switch (condition.type) {
                case FACTION: {
                    json.addProperty("faction", condition.faction.getID().toString());
                }
                case ANY_FACTION: {
                    json.addProperty("min_level", (Number)condition.minLevel);
                    if (condition.maxLevel == -1) break;
                    json.addProperty("max_level", (Number)condition.maxLevel);
                }
            }
        }

        @Nonnull
        public FactionCondition deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext context) {
            JsonObject json = jsonObject.get("predicate").getAsJsonObject();
            Type type = Type.valueOf(json.get("type").getAsString());
            switch (type) {
                case NO_FACTION: {
                    return new FactionCondition();
                }
                case ANY_FACTION: {
                    int minLevel = json.has("min_level") ? json.get("min_level").getAsInt() : 0;
                    int maxLevel = json.has("max_level") ? json.get("max_level").getAsInt() : -1;
                    return new FactionCondition(minLevel, maxLevel);
                }
                case FACTION: {
                    ResourceLocation factionId = new ResourceLocation(json.get("faction").getAsString());
                    IFaction faction = VampirismAPI.factionRegistry().getFactionByID(factionId);
                    int minLevel = json.has("min_level") ? json.get("min_level").getAsInt() : 0;
                    int maxLevel = json.has("max_level") ? json.get("max_level").getAsInt() : -1;
                    return new FactionCondition(faction instanceof PlayableFaction ? (PlayableFaction)faction : null, minLevel, maxLevel);
                }
            }
            return null;
        }
    }

    public static enum Type {
        NO_FACTION,
        ANY_FACTION,
        FACTION;

    }
}

