/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.api.common.data;

import java.util.Objects;
import java.util.StringJoiner;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class GlobalBlockPos
implements INBTSerializable<CompoundNBT> {
    protected BlockPos pos;
    protected RegistryKey<World> dimensionKey;

    public GlobalBlockPos() {
    }

    public GlobalBlockPos(BlockPos pos, RegistryKey<World> dimensionKey) {
        this.pos = pos;
        this.dimensionKey = dimensionKey;
    }

    public GlobalBlockPos(BlockPos pos, World world) {
        this.pos = pos;
        this.dimensionKey = world.func_234923_W_();
    }

    public static GlobalBlockPos from(CompoundNBT compound) {
        GlobalBlockPos globalBlockPos = new GlobalBlockPos();
        globalBlockPos.deserializeNBT(compound);
        return globalBlockPos;
    }

    public static GlobalBlockPos from(PacketBuffer buf) {
        GlobalBlockPos globalBlockPos = new GlobalBlockPos();
        globalBlockPos.decode(buf);
        return globalBlockPos;
    }

    public static GlobalBlockPos from(TileEntity tileEntity) {
        return new GlobalBlockPos(tileEntity.func_174877_v(), tileEntity.func_145831_w());
    }

    public RegistryKey<World> getDimensionKey() {
        return this.dimensionKey;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int hashCode() {
        return Objects.hash(this.dimensionKey, this.pos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalBlockPos other = (GlobalBlockPos)obj;
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        return this.dimensionKey.equals(other.dimensionKey);
    }

    public String toString() {
        return new StringJoiner(", ", "[", "]").add(this.dimensionKey.func_240901_a_().toString()).add("x=" + this.pos.func_177958_n()).add("y=" + this.pos.func_177956_o()).add("z=" + this.pos.func_177952_p()).toString();
    }

    public CompoundNBT serializeNBT() {
        return this.write(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.read(nbt);
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74772_a("pos", this.getPos().func_218275_a());
        compound.func_74778_a("dimension", this.dimensionKey.func_240901_a_().toString());
        return compound;
    }

    public void read(CompoundNBT compound) {
        this.pos = BlockPos.func_218283_e((long)compound.func_74763_f("pos"));
        this.dimensionKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("dimension")));
    }

    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_192572_a(this.dimensionKey.func_240901_a_());
    }

    public void decode(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.dimensionKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
    }
}

