/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class LabelWidget
extends Widget {
    public List<String> lines = new ArrayList<String>();
    public boolean centered = false;
    public boolean rightAligned = false;
    public int field_230688_j_ = 0;
    public int margin = 2;
    public boolean shadow = false;

    public LabelWidget(int xIn, int yIn) {
        this(xIn, yIn, false);
    }

    public LabelWidget(int xIn, int yIn, boolean centered) {
        this(xIn, yIn, centered, -1, -1);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height) {
        this(xIn, yIn, centered, width, height, 2);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height, int margin) {
        this(xIn, yIn, centered, width, height, margin, 0xFFFFFF);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height, int margin, int color) {
        super(xIn, yIn, width, height, (ITextComponent)new StringTextComponent(""));
        this.centered = centered;
        this.field_230688_j_ = width;
        this.margin = margin;
        this.packedFGColor = color;
        this.field_230693_o_ = false;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.centered && this.field_230688_j_ <= 0 && this.lines.size() > 0) {
                this.field_230688_j_ = fontrenderer.func_78256_a(this.lines.get(0));
            }
            int color = this.getFGColor();
            for (int i = 0; i < this.lines.size(); ++i) {
                fontrenderer.getClass();
                int top = this.field_230691_m_ + i * (9 + this.margin);
                if (this.centered) {
                    this.drawCenteredLabelString(stack, fontrenderer, this.lines.get(i), this.field_230690_l_, top, color);
                    continue;
                }
                if (this.rightAligned) {
                    this.drawRightAlignedLabelString(stack, fontrenderer, this.lines.get(i), this.field_230690_l_, top, color);
                    continue;
                }
                this.drawLabelString(stack, fontrenderer, this.lines.get(i), this.field_230690_l_, top, color);
            }
        }
    }

    public void drawCenteredLabelString(MatrixStack stack, FontRenderer fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.func_238405_a_(stack, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        } else {
            fontRenderer.func_238421_b_(stack, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        }
    }

    public void drawRightAlignedLabelString(MatrixStack stack, FontRenderer fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.func_238405_a_(stack, text, (float)(x - fontRenderer.func_78256_a(text)), (float)y, color);
        } else {
            fontRenderer.func_238421_b_(stack, text, (float)(x - fontRenderer.func_78256_a(text)), (float)y, color);
        }
    }

    public void drawLabelString(MatrixStack stack, FontRenderer fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.func_238405_a_(stack, text, (float)x, (float)y, color);
        } else {
            fontRenderer.func_238421_b_(stack, text, (float)x, (float)y, color);
        }
    }

    public LabelWidget alignRight(boolean align) {
        this.rightAligned = align;
        if (this.rightAligned) {
            this.centered = false;
        }
        return this;
    }

    public void addLine(String string, boolean translate) {
        if (translate) {
            this.addLine(I18n.func_135052_a((String)string, (Object[])new Object[0]));
        } else {
            this.addLine(string);
        }
    }

    public void addLine(String string) {
        this.lines.add(string);
    }

    public void addLine(ITextComponent component) {
        this.lines.add(component.getString());
    }
}

