/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.spirit;

import com.github.klikli_dev.occultism.client.gui.controls.SizedImageButton;
import com.github.klikli_dev.occultism.client.gui.spirit.SpiritGui;
import com.github.klikli_dev.occultism.common.container.spirit.SpiritTransporterContainer;
import com.github.klikli_dev.occultism.network.MessageSetFilterMode;
import com.github.klikli_dev.occultism.network.MessageSetTagFilterText;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.commons.lang3.StringUtils;

public class SpiritTransporterGui
extends SpiritGui<SpiritTransporterContainer> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("occultism", "textures/gui/inventory_spirit_transporter_tagfilter.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.spirit.transporter";
    protected final List<ITextComponent> tooltip = new ArrayList<ITextComponent>();
    protected SpiritTransporterContainer container;
    protected Button filterModeButton;
    protected TextFieldWidget tagFilterTextField;
    protected String tagFilter;

    public SpiritTransporterGui(SpiritTransporterContainer container, PlayerInventory playerInventory, ITextComponent titleIn) {
        super(container, playerInventory, titleIn);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 202;
    }

    public boolean isBlacklist() {
        return this.spirit.isFilterBlacklist();
    }

    public String getTagFilterText() {
        return this.tagFilter;
    }

    public void setTagFilterText(String tagFilterText) {
        this.tagFilter = tagFilterText;
    }

    public void setIsBlacklist(boolean isBlacklist) {
        this.spirit.setFilterBlacklist(isBlacklist);
        OccultismPackets.sendToServer(new MessageSetFilterMode(isBlacklist, this.spirit.func_145782_y()));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.setTagFilterText(this.spirit.getTagFilter());
        int isBlacklistButtonTop = 83;
        int isBlacklistButtonLeft = 151;
        int buttonSize = 18;
        int isBlacklistOffset = (this.isBlacklist() ? 0 : 1) * 20;
        this.filterModeButton = new SizedImageButton(this.field_147003_i + isBlacklistButtonLeft, this.field_147009_r + isBlacklistButtonTop, buttonSize, buttonSize, 177, isBlacklistOffset, 20, 20, 20, 256, 256, TEXTURE, button -> {
            this.setIsBlacklist(!this.isBlacklist());
            this.func_231160_c_();
        });
        this.func_230480_a_((Widget)this.filterModeButton);
        int tagFilterLeft = 8;
        int tagFilterTop = 105;
        int tagFilterWidth = 124;
        this.field_230712_o_.getClass();
        this.tagFilterTextField = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + tagFilterLeft, this.field_147009_r + tagFilterTop, tagFilterWidth, 9, (ITextComponent)new StringTextComponent("forge:ores;*logs*;item:minecraft:chest"));
        this.tagFilterTextField.func_146203_f(90);
        this.tagFilterTextField.func_146185_a(false);
        this.tagFilterTextField.func_146189_e(true);
        this.tagFilterTextField.func_146193_g(Color.WHITE.getRGB());
        this.tagFilterTextField.func_146195_b(false);
        if (!StringUtils.isBlank((CharSequence)this.getTagFilterText())) {
            this.tagFilterTextField.func_146180_a(this.getTagFilterText());
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderSystem.pushMatrix();
        int scale = 30;
        SpiritTransporterGui.drawEntityToGui(this.field_147003_i + 35, this.field_147009_r + 65, scale, this.field_147003_i + 51 - x, this.field_147009_r + 75 - 50 - y, (LivingEntity)this.spirit);
        RenderSystem.popMatrix();
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.tooltip.clear();
        if (this.filterModeButton.func_230449_g_()) {
            this.tooltip.add((ITextComponent)new TranslationTextComponent("gui.occultism.spirit.transporter.filter_mode"));
            this.tooltip.add((ITextComponent)new TranslationTextComponent("gui.occultism.spirit.transporter.filter_mode." + (this.isBlacklist() ? "blacklist" : "whitelist")).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.isPointInSearchbar(mouseX, mouseY)) {
            this.tooltip.add((ITextComponent)new TranslationTextComponent("gui.occultism.spirit.transporter.tag_filter"));
        }
        if (!this.tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, this.tooltip, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.tagFilterTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.isPointInSearchbar(mouseX, mouseY) && mouseButton == 1) {
            this.tagFilterTextField.func_146180_a("");
            this.setTagFilterText("");
        }
        if (this.tagFilterTextField.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey;
        this.setTagFilterText(this.tagFilterTextField.func_146179_b());
        if (this.tagFilterTextField.func_230999_j_() && this.tagFilterTextField.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.tagFilterTextField.func_230999_j_() && this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.tagFilterTextField.func_146195_b(false);
        this.spirit.setTagFilter(this.tagFilter);
        OccultismPackets.sendToServer(new MessageSetTagFilterText(this.tagFilter, this.spirit.func_145782_y()));
    }

    public void func_231023_e_() {
        this.tagFilterTextField.func_146178_a();
        super.func_231023_e_();
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.tagFilterTextField.func_230999_j_() && this.tagFilterTextField.func_231042_a_(codePoint, modifiers)) {
            this.setTagFilterText(this.tagFilterTextField.func_146179_b());
        }
        return false;
    }

    protected boolean isPointInSearchbar(double mouseX, double mouseY) {
        int n = this.tagFilterTextField.field_230690_l_ - this.field_147003_i;
        int n2 = this.tagFilterTextField.field_230691_m_ - this.field_147009_r;
        int n3 = this.tagFilterTextField.func_230998_h_() - 5;
        this.field_230712_o_.getClass();
        return this.func_195359_a(n, n2, n3, 9 + 6, mouseX, mouseY);
    }
}

