/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.itemproperties;

import com.github.klikli_dev.occultism.common.item.tool.GuideBookItem;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

@OnlyIn(value=Dist.CLIENT)
public class GuideBookItemPropertyGetter
implements IItemPropertyGetter {
    @OnlyIn(value=Dist.CLIENT)
    public float call(ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
        Book book = (Book)BookRegistry.INSTANCE.books.get(GuideBookItem.GUIDE);
        float progression = 0.0f;
        if (book != null) {
            int totalEntries = 0;
            int unlockedEntries = 0;
            for (BookEntry entry : book.contents.entries.values()) {
                if (entry.isSecret()) continue;
                ++totalEntries;
                if (entry.isLocked()) continue;
                ++unlockedEntries;
            }
            progression = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        }
        return progression;
    }
}

