/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.GreedyFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class GreedyFamiliarModel
extends EntityModel<GreedyFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelRenderer body;
    public ModelRenderer rightArm;
    public ModelRenderer chest1;
    public ModelRenderer leftArm;
    public ModelRenderer rightLeg;
    public ModelRenderer leftLeg;
    public ModelRenderer head;
    public ModelRenderer chest2;
    public ModelRenderer monster;
    public ModelRenderer monsterLeftEye;
    public ModelRenderer monsterRightEye;
    public ModelRenderer monsterLeftEar;
    public ModelRenderer monsterRightEar;
    public ModelRenderer leftEar;
    public ModelRenderer rightEar;
    public ModelRenderer nose;

    public GreedyFamiliarModel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.body = new ModelRenderer((Model)this, 0, 10);
        this.body.func_78793_a(0.0f, 19.0f, 0.6f);
        this.body.func_228302_a_(-2.5f, -5.0f, -1.5f, 5.0f, 5.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_78793_a(0.0f, -5.0f, 0.0f);
        this.head.func_228302_a_(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.rightArm = new ModelRenderer((Model)this, 16, 21);
        this.rightArm.field_78809_i = true;
        this.rightArm.func_78793_a(-2.5f, -5.0f, 0.0f);
        this.rightArm.func_228302_a_(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.leftEar = new ModelRenderer((Model)this, 0, 0);
        this.leftEar.func_78793_a(2.0f, -4.5f, 0.0f);
        this.leftEar.func_228302_a_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftEar, 0.0f, 0.0f, 0.5235988f);
        this.chest2 = new ModelRenderer((Model)this, 0, 18);
        this.chest2.func_78793_a(0.0f, -3.0f, 0.0f);
        this.chest2.func_228302_a_(-2.0f, -2.0f, 0.0f, 4.0f, 2.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.chest2, 1.0555751f, 0.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 8, 24);
        this.leftLeg.func_78793_a(1.5f, 0.0f, 0.0f);
        this.leftLeg.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.monster = new ModelRenderer((Model)this, 15, 0);
        this.monster.func_78793_a(0.0f, -2.0f, 1.5f);
        this.monster.func_228302_a_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.monster, 0.1563815f, -0.11728612f, 0.0f);
        this.monsterRightEye = new ModelRenderer((Model)this, 21, 0);
        this.monsterRightEye.field_78809_i = true;
        this.monsterRightEye.func_78793_a(0.8f, -1.8f, 1.8f);
        this.monsterRightEye.func_228302_a_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.rightEar = new ModelRenderer((Model)this, 0, 0);
        this.rightEar.field_78809_i = true;
        this.rightEar.func_78793_a(-2.0f, -4.5f, 0.0f);
        this.rightEar.func_228302_a_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightEar, 0.0f, 0.0f, -0.5235988f);
        this.chest1 = new ModelRenderer((Model)this, 12, 14);
        this.chest1.func_78793_a(0.0f, 0.5f, 1.5f);
        this.chest1.func_228302_a_(-2.0f, -3.0f, 0.0f, 4.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.monsterLeftEar = new ModelRenderer((Model)this, 24, 0);
        this.monsterLeftEar.func_78793_a(-0.6f, -1.6f, 0.3f);
        this.monsterLeftEar.func_228302_a_(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.monsterLeftEar, -0.312763f, 0.07819075f, -0.35185838f);
        this.rightLeg = new ModelRenderer((Model)this, 8, 24);
        this.rightLeg.field_78809_i = true;
        this.rightLeg.func_78793_a(-1.5f, 0.0f, 0.0f);
        this.rightLeg.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.monsterRightEar = new ModelRenderer((Model)this, 24, 0);
        this.monsterRightEar.func_78793_a(0.6f, -1.6f, 0.3f);
        this.monsterRightEar.func_228302_a_(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.monsterRightEar, -0.312763f, 0.07819075f, 0.35185838f);
        this.nose = new ModelRenderer((Model)this, 18, 8);
        this.nose.func_78793_a(0.0f, -3.0f, -2.5f);
        this.nose.func_228302_a_(-1.0f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 16, 21);
        this.leftArm.func_78793_a(2.5f, -5.0f, 0.0f);
        this.leftArm.func_228302_a_(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.monsterLeftEye = new ModelRenderer((Model)this, 21, 0);
        this.monsterLeftEye.func_78793_a(-0.8f, -1.8f, 1.8f);
        this.monsterLeftEye.func_228302_a_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(this.head);
        this.body.func_78792_a(this.rightArm);
        this.head.func_78792_a(this.leftEar);
        this.chest1.func_78792_a(this.chest2);
        this.body.func_78792_a(this.leftLeg);
        this.chest1.func_78792_a(this.monster);
        this.monster.func_78792_a(this.monsterRightEye);
        this.head.func_78792_a(this.rightEar);
        this.body.func_78792_a(this.chest1);
        this.monster.func_78792_a(this.monsterLeftEar);
        this.body.func_78792_a(this.rightLeg);
        this.monster.func_78792_a(this.monsterRightEar);
        this.head.func_78792_a(this.nose);
        this.body.func_78792_a(this.leftArm);
        this.monster.func_78792_a(this.monsterLeftEye);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public void prepareMobModel(GreedyFamiliarEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.leftEar.field_78808_h = -pEntity.getEarRotZ(pPartialTick);
        this.rightEar.field_78808_h = pEntity.getEarRotZ(pPartialTick);
        this.leftEar.field_78795_f = pEntity.getEarRotX(pPartialTick);
        this.rightEar.field_78795_f = pEntity.getEarRotX(pPartialTick);
        float ageInTicks = (float)pEntity.field_70173_aa + pPartialTick;
        if (!pEntity.isPartying()) {
            this.chest2.field_78795_f = pEntity.getLidRot(pPartialTick);
            this.monster.field_78797_d = -0.2f - pEntity.getLidRot(pPartialTick) * 3.0f;
            this.monster.field_78796_g = pEntity.getMonsterRot(pPartialTick);
            this.monster.field_78795_f = 0.0f;
        } else {
            this.chest2.field_78795_f = this.toRad(40.0f);
            this.monster.field_78797_d = -2.5f;
            this.monster.field_78796_g = 0.0f;
            this.monster.field_78795_f = MathHelper.func_76134_b((float)ageInTicks) * this.toRad(15.0f);
        }
    }

    public void setupAnim(GreedyFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78808_h = 0.0f;
        this.rightArm.field_78808_h = 0.0f;
        this.leftArm.field_78808_h = 0.0f;
        if (entityIn.isPartying()) {
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks + (float)Math.PI)) * this.toRad(20.0f) + this.toRad(180.0f);
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)ageInTicks) * this.toRad(20.0f) + this.toRad(180.0f);
            this.rightArm.field_78808_h = -this.toRad(20.0f);
            this.leftArm.field_78808_h = this.toRad(20.0f);
            this.head.field_78808_h = MathHelper.func_76126_a((float)ageInTicks) * this.toRad(20.0f);
            if (entityIn.func_184187_bx() == null) {
                this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount;
                this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            } else {
                this.rightLeg.field_78795_f = -1.5707964f;
                this.leftLeg.field_78795_f = -1.5707964f;
            }
        } else if (entityIn.isSitting() || entityIn.func_184187_bx() != null) {
            this.rightArm.field_78795_f = 0.0f;
            this.leftArm.field_78795_f = 0.0f;
            this.rightLeg.field_78795_f = -1.5707964f;
            this.leftLeg.field_78795_f = -1.5707964f;
        } else {
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * limbSwingAmount;
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        this.chest1.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f;
        if (entityIn.getTargetBlock().isPresent()) {
            this.rightArm.field_78795_f = -this.toRad(100.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount;
        }
    }
}

