/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.github.klikli_dev.occultism.client.render.entity.DragonRendering;
import com.github.klikli_dev.occultism.common.entity.DragonFamiliarEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class DragonFamiliarRenderer
extends MobRenderer<DragonFamiliarEntity, DragonFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/dragon_familiar.png");

    public DragonFamiliarRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new DragonFamiliarModel(), 0.3f);
        this.func_177094_a(new DragonRendering.StickLayer((IEntityRenderer<DragonFamiliarEntity, DragonFamiliarModel>)this));
        this.func_177094_a(new DragonRendering.SwordLayer((IEntityRenderer<DragonFamiliarEntity, DragonFamiliarModel>)this));
    }

    public void render(DragonFamiliarEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(DragonFamiliarEntity entity) {
        return TEXTURES;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="occultism", value={Dist.CLIENT})
    private static class RenderText {
        private RenderText() {
        }

        @SubscribeEvent
        public static void renderText(RenderLivingEvent<DragonFamiliarEntity, DragonFamiliarModel> event) {
            if (!(event.getEntity() instanceof DragonFamiliarEntity)) {
                return;
            }
            DragonFamiliarEntity dragon = (DragonFamiliarEntity)event.getEntity();
            float partialTicks = event.getPartialRenderTick();
            float textTimer = (float)dragon.getPetTimer() + partialTicks;
            if (textTimer >= 40.0f) {
                return;
            }
            float height = dragon.func_213302_cg() + 0.5f;
            TranslationTextComponent text = new TranslationTextComponent("dialog.occultism.dragon.pet");
            MatrixStack matrixStackIn = event.getMatrixStack();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)(height + textTimer / 20.0f), 0.0);
            matrixStackIn.func_227863_a_(event.getRenderer().func_177068_d().func_229098_b_());
            matrixStackIn.func_227861_a_((double)MathHelper.func_76126_a((float)(textTimer / 2.0f)) * 0.5, 0.0, 0.0);
            float size = (1.0f - textTimer / 40.0f) * 0.025f;
            matrixStackIn.func_227862_a_(-size, -size, size);
            Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
            FontRenderer font = event.getRenderer().func_177068_d().func_78716_a();
            font.func_243247_a((ITextComponent)text, (float)(-font.func_238414_a_((ITextProperties)text)) / 2.0f, 0.0f, 0xFFFFFF, false, matrix, event.getBuffers(), false, 0, event.getLight());
            matrixStackIn.func_227865_b_();
        }
    }
}

