/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.GreedyFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.GreedyFamiliarEntity;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;

public class GreedyFamiliarRenderer
extends MobRenderer<GreedyFamiliarEntity, GreedyFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/greedy_familiar.png");

    public GreedyFamiliarRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new GreedyFamiliarModel(), 0.3f);
        this.func_177094_a(new ItemLayer((IEntityRenderer<GreedyFamiliarEntity, GreedyFamiliarModel>)this));
        this.func_177094_a(new GreedyFamiliarChest((IEntityRenderer<GreedyFamiliarEntity, GreedyFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(GreedyFamiliarEntity entity) {
        return TEXTURES;
    }

    public void render(GreedyFamiliarEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    private static class ItemLayer
    extends LayerRenderer<GreedyFamiliarEntity, GreedyFamiliarModel> {
        public ItemLayer(IEntityRenderer<GreedyFamiliarEntity, GreedyFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, GreedyFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean hasBlacksmithUpgrade = entitylivingbaseIn.hasBlacksmithUpgrade();
            ItemStack offhand = entitylivingbaseIn.func_184592_cb();
            if (!hasBlacksmithUpgrade && offhand.func_190926_b()) {
                return;
            }
            GreedyFamiliarModel model = (GreedyFamiliarModel)this.func_215332_c();
            FirstPersonRenderer renderer = Minecraft.func_71410_x().func_175597_ag();
            matrixStackIn.func_227860_a_();
            if (hasBlacksmithUpgrade) {
                model.body.func_228307_a_(matrixStackIn);
                model.rightArm.func_228307_a_(matrixStackIn);
                matrixStackIn.func_227861_a_(-0.06, 0.2, -0.1);
                matrixStackIn.func_227863_a_(new Quaternion(0.0f, 90.0f, -45.0f, true));
                renderer.func_228397_a_((LivingEntity)entitylivingbaseIn, new ItemStack((IItemProvider)Items.field_151035_b), ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.func_227865_b_();
            }
            if (!offhand.func_190926_b()) {
                matrixStackIn.func_227860_a_();
                model.body.func_228307_a_(matrixStackIn);
                model.leftArm.func_228307_a_(matrixStackIn);
                matrixStackIn.func_227861_a_(0.06, 0.2, -0.17);
                matrixStackIn.func_227863_a_(new Quaternion(0.0f, 45.0f, 0.0f, true));
                float size = 0.75f;
                matrixStackIn.func_227862_a_(size, size, size);
                renderer.func_228397_a_((LivingEntity)entitylivingbaseIn, offhand, ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    private static class GreedyFamiliarChest
    extends LayerRenderer<GreedyFamiliarEntity, GreedyFamiliarModel> {
        private static final ResourceLocation CHEST = new ResourceLocation("occultism", "textures/entity/greedy_familiar_chest.png");
        private static final ResourceLocation CHRISTMAS = new ResourceLocation("occultism", "textures/entity/greedy_familiar_christmas.png");

        public GreedyFamiliarChest(IEntityRenderer<GreedyFamiliarEntity, GreedyFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, GreedyFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.func_82150_aj()) {
                return;
            }
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)(FamiliarUtil.isChristmas() ? CHRISTMAS : CHEST)));
            GreedyFamiliarModel model = (GreedyFamiliarModel)this.func_215332_c();
            model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

