/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.GuardianFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.GuardianFamiliarEntity;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;

public class GuardianFamiliarRenderer
extends MobRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/guardian_familiar.png");

    public GuardianFamiliarRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new GuardianFamiliarModel(), 0.3f);
        this.func_177094_a(new GuardianFamiliarOverlay((IEntityRenderer<GuardianFamiliarEntity, GuardianFamiliarModel>)this));
        this.func_177094_a(new ToolsLayer((IEntityRenderer<GuardianFamiliarEntity, GuardianFamiliarModel>)this));
        this.func_177094_a(new GuardianFamiliarTree((IEntityRenderer<GuardianFamiliarEntity, GuardianFamiliarModel>)this));
    }

    public void render(GuardianFamiliarEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        boolean noLegs;
        matrixStackIn.func_227860_a_();
        boolean bl = noLegs = entityIn.getLives() <= 2;
        matrixStackIn.func_227861_a_(0.0, entityIn.isSitting() ? (noLegs ? -0.5 : -0.36) : (double)entityIn.getAnimationHeight(partialTicks) * 0.08, 0.0);
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(GuardianFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class GuardianFamiliarTree
    extends LayerRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        private static final ResourceLocation TREE = new ResourceLocation("occultism", "textures/entity/guardian_familiar_tree.png");
        private static final ResourceLocation CHRISTMAS = new ResourceLocation("occultism", "textures/entity/guardian_familiar_christmas.png");

        public GuardianFamiliarTree(IEntityRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, GuardianFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.func_82150_aj()) {
                return;
            }
            boolean isChristmas = FamiliarUtil.isChristmas();
            boolean hasTree = entitylivingbaseIn.hasTree();
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)(isChristmas ? CHRISTMAS : TREE)));
            GuardianFamiliarModel model = (GuardianFamiliarModel)this.func_215332_c();
            model.tree1.field_78806_j = isChristmas || hasTree;
            model.tree2.field_78806_j = isChristmas || hasTree;
            model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static class ToolsLayer
    extends LayerRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        public ToolsLayer(IEntityRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrix, IRenderTypeBuffer bufferIn, int light, GuardianFamiliarEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.func_82150_aj() || !entity.hasTools()) {
                return;
            }
            FirstPersonRenderer itemRenderer = Minecraft.func_71410_x().func_175597_ag();
            ItemCameraTransforms.TransformType ground = ItemCameraTransforms.TransformType.GROUND;
            GuardianFamiliarModel model = (GuardianFamiliarModel)this.func_215332_c();
            matrix.func_227860_a_();
            model.body.func_228307_a_(matrix);
            matrix.func_227861_a_(-0.15, -0.25, -0.25);
            matrix.func_227863_a_(new Quaternion(0.0f, -60.0f, 0.0f, true));
            itemRenderer.func_228397_a_((LivingEntity)entity, new ItemStack((IItemProvider)Items.field_151052_q), ground, false, matrix, bufferIn, light);
            matrix.func_227865_b_();
            matrix.func_227860_a_();
            model.body.func_228307_a_(matrix);
            matrix.func_227861_a_(-0.15, 0.1, 0.37);
            matrix.func_227863_a_(new Quaternion(0.0f, 60.0f, -110.0f, true));
            itemRenderer.func_228397_a_((LivingEntity)entity, new ItemStack((IItemProvider)Items.field_151049_t), ground, false, matrix, bufferIn, light);
            matrix.func_227865_b_();
            if (model.leftArm1.field_78806_j) {
                matrix.func_227860_a_();
                model.body.func_228307_a_(matrix);
                model.leftArm1.func_228307_a_(matrix);
                matrix.func_227861_a_(0.21, 0.2, 0.0);
                matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 210.0f, true));
                itemRenderer.func_228397_a_((LivingEntity)entity, new ItemStack((IItemProvider)Items.field_151050_s), ground, false, matrix, bufferIn, light);
                matrix.func_227865_b_();
            }
        }
    }

    private static class GuardianFamiliarOverlay
    extends LayerRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        private static final ResourceLocation OVERLAY = new ResourceLocation("occultism", "textures/entity/guardian_familiar_overlay.png");
        private final GuardianFamiliarModel model = new GuardianFamiliarModel();

        public GuardianFamiliarOverlay(IEntityRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, GuardianFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entitylivingbaseIn.func_82150_aj()) {
                ((GuardianFamiliarModel)this.func_215332_c()).func_217111_a(this.model);
                this.model.func_212843_a_((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
                this.model.setupAnim(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)OVERLAY));
                this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), entitylivingbaseIn.getRed(), entitylivingbaseIn.getGreen(), entitylivingbaseIn.getBlue(), (MathHelper.func_76134_b((float)(ageInTicks / 20.0f)) + 1.0f) * 0.3f + 0.4f);
            }
        }
    }
}

