/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.CthulhuFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.HeadlessFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.HeadlessFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;

public class HeadlessFamiliarRenderer
extends MobRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("occultism", "textures/entity/headless_familiar.png");

    public HeadlessFamiliarRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new HeadlessFamiliarModel(), 0.3f);
        this.func_177094_a(new HeadLayer((IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.func_177094_a(new WeaponLayer((IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.func_177094_a(new RebuiltLayer((IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.func_177094_a(new PumpkinLayer((IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(HeadlessFamiliarEntity entity) {
        return TEXTURE;
    }

    public void render(HeadlessFamiliarEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        if (entityIn.isSitting()) {
            matrixStackIn.func_227861_a_(0.0, -0.12, 0.0);
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    private static class CthulhuHeadModel
    extends GenericHeadModel {
        private final CthulhuFamiliarModel model = new CthulhuFamiliarModel();

        private CthulhuHeadModel() {
        }

        public void func_225598_a_(MatrixStack pMatrixStack, IVertexBuilder pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            this.model.trunk1.field_78806_j = false;
            this.model.trunk2.field_78806_j = false;
            this.model.trunk3.field_78806_j = false;
            this.model.hat1.field_78806_j = false;
            pMatrixStack.func_227860_a_();
            pMatrixStack.func_227862_a_(1.5f, 1.5f, 1.5f);
            pMatrixStack.func_227861_a_(0.0, 0.35, 0.07);
            pMatrixStack.func_227863_a_(new Quaternion(10.0f, 0.0f, 0.0f, true));
            this.model.head.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay);
            pMatrixStack.func_227865_b_();
        }
    }

    public static class HeadLayer
    extends LayerRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        private static Map<EntityType<?>, ResourceLocation> textures;
        HumanoidHeadModel humanoidHead = new HumanoidHeadModel();
        GenericHeadModel genericHead = new GenericHeadModel(0, 0, 64, 32);
        GenericHeadModel spiderHead = new GenericHeadModel(32, 4, 64, 32);
        GenericHeadModel cthulhuHead = new CthulhuHeadModel();

        public HeadLayer(IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> renderer) {
            super(renderer);
        }

        private static ResourceLocation getTexture(EntityType<?> type) {
            if (textures == null) {
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)EntityType.field_200729_aH, (Object)DefaultPlayerSkin.func_177335_a());
                builder.put((Object)EntityType.field_200725_aD, (Object)new ResourceLocation("textures/entity/zombie/zombie.png"));
                builder.put((Object)EntityType.field_200741_ag, (Object)new ResourceLocation("textures/entity/skeleton/skeleton.png"));
                builder.put((Object)EntityType.field_200722_aA, (Object)new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
                builder.put((Object)EntityType.field_200797_k, (Object)new ResourceLocation("textures/entity/creeper/creeper.png"));
                builder.put((Object)EntityType.field_200748_an, (Object)new ResourceLocation("textures/entity/spider/spider.png"));
                builder.put((Object)OccultismEntities.CTHULHU_FAMILIAR.get(), (Object)new ResourceLocation("occultism", "textures/entity/cthulhu_familiar.png"));
                textures = builder.build();
            }
            return textures.get(type);
        }

        private GenericHeadModel getHeadModel(EntityType<?> type) {
            if (type == EntityType.field_200741_ag || type == EntityType.field_200722_aA || type == EntityType.field_200797_k) {
                return this.genericHead;
            }
            if (type == EntityType.field_200729_aH || type == EntityType.field_200725_aD) {
                return this.humanoidHead;
            }
            if (type == EntityType.field_200748_an) {
                return this.spiderHead;
            }
            if (type == OccultismEntities.CTHULHU_FAMILIAR.get()) {
                return this.cthulhuHead;
            }
            return null;
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, HeadlessFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isHeadlessDead()) {
                return;
            }
            EntityType<? extends LivingEntity> headType = entitylivingbaseIn.getHeadType();
            if (headType == null) {
                return;
            }
            GenericHeadModel head = this.getHeadModel(headType);
            if (head == null) {
                return;
            }
            matrixStackIn.func_227860_a_();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.func_215332_c();
            model.ratBody1.func_228307_a_(matrixStackIn);
            model.body.func_228307_a_(matrixStackIn);
            model.leftArm.func_228307_a_(matrixStackIn);
            float size = 0.5f;
            matrixStackIn.func_227862_a_(size, size, size);
            matrixStackIn.func_227861_a_(0.15, 0.5, -0.12);
            matrixStackIn.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
            ResourceLocation texture = HeadLayer.getTexture(headType);
            if (texture != null) {
                IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)texture));
                head.func_225598_a_(matrixStackIn, builder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private static class PumpkinLayer
    extends LayerRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        private static final ResourceLocation PUMPKIN = new ResourceLocation("occultism", "textures/entity/headless_familiar_pumpkin.png");
        private static final ResourceLocation CHRISTMAS = new ResourceLocation("occultism", "textures/entity/headless_familiar_christmas.png");

        public PumpkinLayer(IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, HeadlessFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.func_82150_aj()) {
                return;
            }
            boolean isChristmas = FamiliarUtil.isChristmas();
            boolean hasPumpkin = !entitylivingbaseIn.hasHead();
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)(isChristmas ? CHRISTMAS : PUMPKIN)));
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.func_215332_c();
            model.pumpkin1.field_78806_j = hasPumpkin;
            model.snowmanHat1.field_78806_j = isChristmas;
            model.snowmanHat2.field_78806_j = isChristmas;
            model.snowmanLeftEye.field_78806_j = isChristmas;
            model.snowmanRightEye.field_78806_j = isChristmas;
            model.snowmanMouth1.field_78806_j = isChristmas;
            model.snowmanMouth2.field_78806_j = isChristmas;
            model.snowmanMouth3.field_78806_j = isChristmas;
            model.snowmanNose.field_78806_j = isChristmas;
            model.pumpkin2.field_78806_j = !isChristmas;
            model.pumpkin3.field_78806_j = !isChristmas;
            model.pumpkin4.field_78806_j = !isChristmas;
            model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static class WeaponLayer
    extends LayerRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        public WeaponLayer(IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, HeadlessFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isHeadlessDead()) {
                return;
            }
            matrixStackIn.func_227860_a_();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.func_215332_c();
            model.ratBody1.func_228307_a_(matrixStackIn);
            model.body.func_228307_a_(matrixStackIn);
            model.rightArm.func_228307_a_(matrixStackIn);
            matrixStackIn.func_227861_a_((double)-0.05f, 0.16, -0.08);
            matrixStackIn.func_227863_a_(new Quaternion(0.0f, 90.0f, -50.0f, true));
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)entitylivingbaseIn, entitylivingbaseIn.getWeaponItem(), ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    private static class RebuiltLayer
    extends LayerRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        public RebuiltLayer(IEntityRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(MatrixStack matrix, IRenderTypeBuffer bufferIn, int packedLightIn, HeadlessFamiliarEntity headless, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!headless.isHeadlessDead()) {
                return;
            }
            FirstPersonRenderer renderer = Minecraft.func_71410_x().func_175597_ag();
            matrix.func_227860_a_();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.func_215332_c();
            model.ratBody1.func_228307_a_(matrix);
            boolean partying = headless.isPartying();
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.RightLeg)) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(0.0f, 130.0f, 0.0f, true));
                matrix.func_227861_a_(0.3, -0.3, 0.0);
                this.renderItem(Items.field_151015_O, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.func_227865_b_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.LeftLeg)) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(0.0f, 50.0f, 0.0f, true));
                matrix.func_227861_a_(0.3, -0.3, 0.0);
                this.renderItem(Items.field_151015_O, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.func_227865_b_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.Body)) {
                matrix.func_227860_a_();
                float size = 1.2f;
                matrix.func_227862_a_(size, size, size);
                matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 0.0f, true));
                matrix.func_227861_a_(0.0, -0.45, -0.05);
                this.renderItem(Items.field_221807_eN, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.func_227861_a_(0.0, -0.25, 0.0);
                this.renderItem(Items.field_221807_eN, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.func_227865_b_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.RightArm)) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(0.0f, 180.0f + (partying ? MathHelper.func_76126_a((float)(ageInTicks / 3.0f)) * 20.0f : 0.0f), 0.0f, true));
                matrix.func_227861_a_(0.25, -0.6, 0.05);
                this.renderItem(Items.field_151055_y, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.func_227865_b_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.LeftArm)) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(0.0f, partying ? MathHelper.func_76126_a((float)(ageInTicks / 3.0f)) * 20.0f : 0.0f, 0.0f, true));
                matrix.func_227861_a_(0.25, -0.6, -0.05);
                this.renderItem(Items.field_151055_y, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.func_227865_b_();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.Head)) {
                matrix.func_227860_a_();
                matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
                matrix.func_227861_a_(0.0, 0.7, -0.06);
                matrix.func_227863_a_(new Quaternion(0.0f, partying ? ageInTicks * 8.0f : -netHeadYaw, 0.0f, true));
                this.renderItem(Items.field_221689_cG, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.func_227865_b_();
            }
            matrix.func_227865_b_();
        }

        private void renderItem(Item item, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, HeadlessFamiliarEntity entitylivingbaseIn, FirstPersonRenderer renderer) {
            renderer.func_228397_a_((LivingEntity)entitylivingbaseIn, new ItemStack((IItemProvider)item), ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
        }
    }
}

