/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.tile;

import com.github.klikli_dev.occultism.client.model.tile.DimensionalMatrixModel;
import com.github.klikli_dev.occultism.common.tile.StorageControllerTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class StorageControllerGeoRenderer
extends GeoBlockRenderer<StorageControllerTileEntity> {
    private final AnimatedGeoModel<StorageControllerTileEntity> modelProvider;

    public StorageControllerGeoRenderer(TileEntityRendererDispatcher dispatcher) {
        this(dispatcher, new DimensionalMatrixModel());
    }

    public StorageControllerGeoRenderer(TileEntityRendererDispatcher dispatcher, AnimatedGeoModel<StorageControllerTileEntity> modelProvider) {
        super(dispatcher, modelProvider);
        this.modelProvider = modelProvider;
    }

    public void render(StorageControllerTileEntity tile, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation((Object)tile));
        this.modelProvider.setLivingAnimations((Object)tile, this.getUniqueID(tile));
        stack.func_227860_a_();
        stack.func_227861_a_(0.5, 1.25, 0.5);
        long systemTime = System.currentTimeMillis();
        float angle = systemTime / 16L % 360L;
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTextureLocation(tile));
        Color renderColor = this.getRenderColor(tile, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(tile, partialTicks, stack, bufferIn, null, packedLightIn, this.getTextureLocation(tile));
        this.render(model, tile, partialTicks, renderType, stack, bufferIn, null, packedLightIn, OverlayTexture.field_229196_a_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        stack.func_227865_b_();
    }

    public RenderType getRenderType(StorageControllerTileEntity animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228642_d_((ResourceLocation)this.modelProvider.getTextureLocation((Object)animatable));
    }

    public Color getRenderColor(StorageControllerTileEntity animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn) {
        long systemTime = System.currentTimeMillis();
        double systemTimeRadSin8 = Math.sin(Math.toRadians((float)systemTime / 8.0f));
        long colorScale = 100L - Math.abs(systemTime / 16L / 2L % 160L - 80L);
        float saturation = (float)systemTimeRadSin8 * 0.5f + 0.5f;
        return Color.getHSBColor(0.01f * (float)colorScale, saturation, 0.01f * (float)colorScale);
    }
}

