/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.advancement;

import com.github.klikli_dev.occultism.common.ritual.Ritual;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class RitualTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("occultism", "ritual");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public Instance createInstance(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        return new Instance(this.deserializeRitualPredicate(json));
    }

    private RitualPredicate deserializeRitualPredicate(JsonObject json) {
        if (json.has("ritual_id")) {
            return new RitualPredicate(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"ritual_id")), null);
        }
        return RitualPredicate.deserialize(json.get("ritual_predicate"));
    }

    public void trigger(ServerPlayerEntity player, Ritual ritual) {
        this.func_235959_a_(player, instance -> instance.test(player, ritual));
    }

    public static class RitualPredicate {
        public static final RitualPredicate ANY = new RitualPredicate(null, null);
        private final ResourceLocation ritualId;
        private final ResourceLocation ritualFactoryId;

        public RitualPredicate(ResourceLocation ritualId, ResourceLocation ritualFactoryId) {
            this.ritualId = ritualId;
            this.ritualFactoryId = ritualFactoryId;
        }

        public static RitualPredicate deserialize(JsonElement element) {
            if (element == null || element.isJsonNull()) {
                return ANY;
            }
            ResourceLocation ritualId = null;
            ResourceLocation ritualFactoryId = null;
            JsonObject json = JSONUtils.func_151210_l((JsonElement)element, (String)"ritual_predicate");
            if (json.has("ritual_id")) {
                ritualId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"ritual_id"));
            }
            if (json.has("ritual_factory_id")) {
                ritualFactoryId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"ritual_factory_id"));
            }
            return new RitualPredicate(ritualId, ritualFactoryId);
        }

        public boolean test(Ritual ritual) {
            if (this == ANY) {
                return true;
            }
            if (this.ritualId != null && !this.ritualId.equals((Object)ritual.getRecipe().func_199560_c())) {
                return false;
            }
            return this.ritualFactoryId == null || this.ritualFactoryId.equals((Object)ritual.getFactoryID());
        }

        public JsonElement serialize() {
            if (this == ANY) {
                return JsonNull.INSTANCE;
            }
            JsonObject json = new JsonObject();
            if (this.ritualId != null) {
                json.addProperty("ritual_id", this.ritualId.toString());
            }
            if (this.ritualFactoryId != null) {
                json.addProperty("ritual_factory_id", this.ritualFactoryId.toString());
            }
            return json;
        }
    }

    public static class Instance
    extends CriterionInstance {
        RitualPredicate ritualPredicate;

        public Instance(RitualPredicate ritualPredicate) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.ritualPredicate = ritualPredicate;
        }

        public JsonObject func_230240_a_(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.func_230240_a_(conditions);
            jsonobject.add("ritual_predicate", this.ritualPredicate.serialize());
            return jsonobject;
        }

        public boolean test(ServerPlayerEntity player, Ritual ritual) {
            return this.ritualPredicate.test(ritual);
        }
    }
}

