/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block;

import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.StorageUtil;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DimensionalMineshaftBlock
extends Block {
    private static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)1.0, (double)10.0), Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)10.0), Block.func_208617_a((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)6.0), Block.func_208617_a((double)10.0, (double)1.0, (double)6.0, (double)15.0, (double)2.0, (double)10.0), Block.func_208617_a((double)2.0, (double)2.0, (double)6.0, (double)6.0, (double)3.0, (double)10.0), Block.func_208617_a((double)1.0, (double)1.0, (double)6.0, (double)6.0, (double)2.0, (double)10.0), Block.func_208617_a((double)10.0, (double)2.0, (double)6.0, (double)14.0, (double)3.0, (double)10.0), Block.func_208617_a((double)10.0, (double)3.0, (double)6.0, (double)13.0, (double)4.0, (double)10.0), Block.func_208617_a((double)1.0, (double)1.0, (double)10.0, (double)15.0, (double)2.0, (double)15.0), Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)6.0), Block.func_208617_a((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)3.0, (double)14.0), Block.func_208617_a((double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)4.0, (double)13.0), Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)4.0, (double)6.0), Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0, (double)6.0), Block.func_208617_a((double)3.0, (double)3.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public DimensionalMineshaftBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile != null) {
                StorageUtil.dropInventoryItems(tile);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_196266_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, PathType pType) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)OccultismTiles.DIMENSIONAL_MINESHAFT.get()).func_200968_a();
    }
}

