/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.capability;

import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DoubleJumpCapability {
    private int jumps = 0;

    public int getJumps() {
        return this.jumps;
    }

    public void setJumps(int i) {
        this.jumps = i;
    }

    public void addJump() {
        ++this.jumps;
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("jumps", this.jumps);
        return compound;
    }

    public CompoundNBT read(CompoundNBT compound) {
        this.jumps = compound.func_74762_e("jumps");
        return compound;
    }

    public static class Dispatcher
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<DoubleJumpCapability> doubleJumpCapability = LazyOptional.of(DoubleJumpCapability::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == OccultismCapabilities.DOUBLE_JUMP) {
                return this.doubleJumpCapability.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            this.doubleJumpCapability.ifPresent(capability -> capability.write(nbt));
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.doubleJumpCapability.ifPresent(capability -> capability.read(nbt));
        }
    }

    public static class Storage
    implements Capability.IStorage<DoubleJumpCapability> {
        public INBT writeNBT(Capability<DoubleJumpCapability> capability, DoubleJumpCapability instance, Direction facing) {
            return instance.write(new CompoundNBT());
        }

        public void readNBT(Capability<DoubleJumpCapability> capability, DoubleJumpCapability instance, Direction side, INBT nbt) {
            instance.read((CompoundNBT)nbt);
        }
    }
}

