/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container;

import com.github.klikli_dev.occultism.common.tile.DimensionalMineshaftTileEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.util.RecipeUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class DimensionalMineshaftContainer
extends Container {
    public ItemStackHandler inputHandler;
    public ItemStackHandler outputHandler;
    public DimensionalMineshaftTileEntity otherworldMiner;
    public PlayerInventory playerInventory;

    public DimensionalMineshaftContainer(int id, PlayerInventory playerInventory, DimensionalMineshaftTileEntity otherworldMiner) {
        super((ContainerType)OccultismContainers.OTHERWORLD_MINER.get(), id);
        this.playerInventory = playerInventory;
        this.otherworldMiner = otherworldMiner;
        this.inputHandler = (ItemStackHandler)otherworldMiner.inputHandler.orElseThrow(ItemHandlerMissingException::new);
        this.outputHandler = (ItemStackHandler)otherworldMiner.outputHandler.orElseThrow(ItemHandlerMissingException::new);
        this.setupMinerInventory();
        this.setupPlayerInventorySlots(playerInventory.field_70458_d);
        this.setupPlayerHotbar(playerInventory.field_70458_d);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player.func_70092_e((double)this.otherworldMiner.func_174877_v().func_177958_n() + 0.5, (double)this.otherworldMiner.func_174877_v().func_177956_o() + 0.5, (double)this.otherworldMiner.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.outputHandler.getSlots() ? !this.func_75135_a(itemstack1, this.outputHandler.getSlots() + 1, this.field_75151_b.size(), true) : (index == this.outputHandler.getSlots() ? !this.func_75135_a(itemstack1, this.outputHandler.getSlots() + 1, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.outputHandler.getSlots() + 1, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected void setupPlayerInventorySlots(PlayerEntity player) {
        int playerInventoryTop = 84;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar(PlayerEntity player) {
        int hotbarTop = 142;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupMinerInventory() {
        int outputGridTop = 17;
        int outputGridLeft = 98;
        int index = 0;
        IItemHandler outputHandler = (IItemHandler)this.otherworldMiner.outputHandler.orElseThrow(ItemHandlerMissingException::new);
        IItemHandler inputHandler = (IItemHandler)this.otherworldMiner.inputHandler.orElseThrow(ItemHandlerMissingException::new);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new OutputSlot(outputHandler, index++, outputGridLeft + j * 18, outputGridTop + i * 18));
            }
        }
        this.func_75146_a((Slot)new InputSlot(inputHandler, 0, 26, 35));
    }

    public class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }

    public class InputSlot
    extends SlotItemHandler {
        public InputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            RecipeManager recipeManager = DimensionalMineshaftContainer.this.otherworldMiner.func_145831_w().func_199532_z();
            return RecipeUtil.isValidIngredient(recipeManager, (IRecipeType)OccultismRecipes.MINER_TYPE.get(), stack);
        }
    }
}

