/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container.storage;

import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.github.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.github.klikli_dev.occultism.common.tile.StorageControllerTileEntity;
import com.github.klikli_dev.occultism.network.MessageUpdateLinkedMachines;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StorageControllerContainer
extends StorageControllerContainerBase {
    protected StorageControllerTileEntity storageController;

    public StorageControllerContainer(int id, PlayerInventory playerInventory, StorageControllerTileEntity storageController) {
        super((ContainerType)OccultismContainers.STORAGE_CONTROLLER.get(), id, playerInventory);
        this.storageController = storageController;
        this.matrix = new StorageControllerCraftingInventory((Container)this, storageController.getMatrix());
        this.orderInventory.func_70299_a(0, storageController.getOrderStack());
        this.setupCraftingOutput();
        this.setupCraftingGrid();
        this.setupOrderInventorySlot();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
        this.func_75130_a((IInventory)this.matrix);
    }

    @Override
    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 56;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    @Override
    public StorageControllerTileEntity getStorageController() {
        return this.storageController;
    }

    @Override
    public boolean isContainerItem() {
        return false;
    }

    @Override
    public void updateCraftingSlots(boolean force) {
        for (int i = 0; i < 9; ++i) {
            this.storageController.getMatrix().put(i, this.matrix.func_70301_a(i));
        }
        if (force) {
            this.storageController.markNetworkDirty();
        }
    }

    @Override
    public void updateOrderSlot(boolean force) {
        this.storageController.setOrderStack(this.orderInventory.func_70301_a(0));
        if (force) {
            this.storageController.markNetworkDirty();
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.result && super.func_94530_a(stack, slot);
    }

    public boolean func_75145_c(PlayerEntity player) {
        BlockPos controllerPosition;
        if (this.storageController == null) {
            return false;
        }
        World world = this.storageController.func_145831_w();
        if (!world.field_72995_K && world.func_82737_E() % 40L == 0L) {
            OccultismPackets.sendTo((ServerPlayerEntity)player, this.storageController.getMessageUpdateStacks());
            OccultismPackets.sendTo((ServerPlayerEntity)player, new MessageUpdateLinkedMachines(this.storageController.getLinkedMachines()));
        }
        return player.func_70092_e((double)(controllerPosition = this.storageController.func_174877_v()).func_177958_n() + 0.5, (double)controllerPosition.func_177956_o() + 0.5, (double)controllerPosition.func_177952_p() + 0.5) <= 64.0;
    }
}

