/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BatFamiliarEntity
extends FamiliarEntity
implements IFlyingAnimal {
    public BatFamiliarEntity(EntityType<? extends BatFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_(Attributes.field_233822_e_, 0.4);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setRibbon(this.func_70681_au().nextDouble() < 0.1);
        this.setTail(this.func_70681_au().nextBoolean());
        this.setHair(this.func_70681_au().nextBoolean());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasRibbon()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        FamiliarEntity.SitGoal sitGoal = new FamiliarEntity.SitGoal(this);
        sitGoal.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.field_70714_bg.func_75776_a(2, (Goal)sitGoal);
        this.field_70714_bg.func_75776_a(3, (Goal)new CannibalismGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator navigator = new FlyingPathNavigator((MobEntity)this, world){

            public boolean func_188555_b(BlockPos pos) {
                BlockState state = this.field_75513_b.func_180495_p(pos);
                return state.func_177230_c().isAir(state, (IBlockReader)this.field_75513_b, pos) || !state.func_185904_a().func_76230_c();
            }
        };
        return navigator;
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isSitting()) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
    }

    public float getAnimationHeight(float partialTicks) {
        return MathHelper.func_76134_b((float)(((float)this.field_70173_aa + partialTicks) / 5.0f));
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        effects.add(new EffectInstance(Effects.field_76439_r, 300, 1, false, false));
        if (this.hasBlacksmithUpgrade()) {
            effects.add(new EffectInstance((Effect)OccultismEffects.BAT_LIFESTEAL.get(), 300, 0, false, false));
        }
        return effects;
    }

    public boolean hasHair() {
        return this.hasVariant(0);
    }

    private void setHair(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasRibbon() {
        return this.hasVariant(1);
    }

    private void setRibbon(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTail() {
        return this.hasVariant(2);
    }

    private void setTail(boolean b) {
        this.setVariant(2, b);
    }

    private static class CannibalismGoal
    extends Goal {
        BatFamiliarEntity bat;
        BatEntity nearby;

        private CannibalismGoal(BatFamiliarEntity bat) {
            this.bat = bat;
        }

        public boolean func_75250_a() {
            this.nearby = this.nearbyBat();
            return this.nearby != null;
        }

        public void func_75249_e() {
            if (this.nearby != null) {
                this.nearby.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.bat), 10.0f);
                OccultismAdvancements.FAMILIAR.trigger(this.bat.getFamiliarOwner(), FamiliarTrigger.Type.BAT_EAT);
            }
        }

        private BatEntity nearbyBat() {
            BatEntity nearby = null;
            List bats = this.bat.field_70170_p.func_217357_a(BatEntity.class, this.bat.func_174813_aQ().func_186662_g(2.0));
            if (!bats.isEmpty()) {
                nearby = (BatEntity)bats.get(0);
            }
            return nearby;
        }
    }
}

