/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.CthulhuFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class BeaverFamiliarEntity
extends FamiliarEntity {
    private BlockPos treeTarget;
    private final SwimmerPathNavigator waterNavigator;
    private final GroundPathNavigator groundNavigator;

    public BeaverFamiliarEntity(EntityType<? extends BeaverFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, worldIn);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, worldIn);
        this.field_70765_h = new CthulhuFamiliarEntity.MoveController(this);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setBigTail(this.func_70681_au().nextDouble() < 0.1);
        this.setEars(this.func_70681_au().nextBoolean());
        this.setWhiskers(this.func_70681_au().nextBoolean());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasBigTail()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new ChopTreeGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new CthulhuFamiliarEntity.FollowOwnerWaterGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean hasWhiskers() {
        return this.hasVariant(0);
    }

    private void setWhiskers(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasEars() {
        return this.hasVariant(1);
    }

    private void setEars(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasBigTail() {
        return this.hasVariant(2);
    }

    private void setBigTail(boolean b) {
        this.setVariant(2, b);
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new EffectInstance((Effect)OccultismEffects.BEAVER_HARVEST.get(), 300));
    }

    public void setTreeTarget(BlockPos pos) {
        this.treeTarget = pos;
    }

    private static class ChopTreeGoal
    extends Goal {
        private BeaverFamiliarEntity beaver;

        private ChopTreeGoal(BeaverFamiliarEntity beaver) {
            this.beaver = beaver;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.beaver.isSitting() && this.beaver.isEffectEnabled(this.beaver.getFamiliarOwner()) && this.beaver.treeTarget != null && this.beaver.field_70170_p.func_180495_p(this.beaver.treeTarget).func_235714_a_((ITag)BlockTags.field_200031_h);
        }

        public void func_75249_e() {
            if (this.beaver.treeTarget == null) {
                return;
            }
            this.beaver.func_70661_as().func_75492_a((double)this.beaver.treeTarget.func_177958_n(), (double)this.beaver.treeTarget.func_177956_o(), (double)this.beaver.treeTarget.func_177952_p(), 1.0);
        }

        public void func_75246_d() {
            if (this.beaver.treeTarget == null) {
                return;
            }
            if (this.beaver.func_70092_e(this.beaver.treeTarget.func_177958_n(), this.beaver.treeTarget.func_177956_o(), this.beaver.treeTarget.func_177952_p()) > 4.0) {
                this.beaver.func_70661_as().func_75492_a((double)this.beaver.treeTarget.func_177958_n(), (double)this.beaver.treeTarget.func_177956_o(), (double)this.beaver.treeTarget.func_177952_p(), 1.0);
            } else {
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                HashSet<BlockPos> harvesting = new HashSet<BlockPos>();
                positions.add(this.beaver.treeTarget);
                while (!positions.isEmpty() && harvesting.size() < 15) {
                    BlockPos pos = (BlockPos)positions.pop();
                    harvesting.add(pos);
                    for (BlockPos p : BlockPos.func_239583_a_((BlockPos)pos, (int)1, (int)1, (int)1)) {
                        if (harvesting.contains(p) || !this.beaver.field_70170_p.func_180495_p(p).func_235714_a_((ITag)BlockTags.field_200031_h)) continue;
                        positions.add(p.func_185334_h());
                        harvesting.add(pos);
                    }
                }
                if (!positions.isEmpty()) {
                    this.beaver.treeTarget = null;
                    return;
                }
                for (BlockPos p : harvesting) {
                    this.beaver.field_70170_p.func_175655_b(p, true);
                }
                this.beaver.treeTarget = null;
                OccultismAdvancements.FAMILIAR.trigger(this.beaver.getFamiliarOwner(), FamiliarTrigger.Type.BEAVER_WOODCHOP);
            }
        }
    }
}

