/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.ColoredFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.ShubNiggurathSpawnEntity;
import com.github.klikli_dev.occultism.network.MessageBeholderAttack;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BeholderFamiliarEntity
extends ColoredFamiliarEntity {
    private static final float DEG_30 = FamiliarUtil.toRads(30.0f);
    private static final int EAT_EFFECT_DURATION = 12000;
    private Eye[] eyes = new Eye[]{new Eye(-0.13, 1.3, -0.13), new Eye(0.13999999999999999, 1.3, -0.13), new Eye(0.18000000000000002, 1.3, 0.16), new Eye(-0.09, 1.3, 0.11000000000000001)};
    private Vector2f bigEyePos;
    private Vector2f bigEyePos0 = this.bigEyeTarget = Vector2f.field_189974_a;
    private Vector2f bigEyeTarget;
    private final float heightOffset;
    private int eatTimer = -1;
    private float mouthRot;
    private float actualMouthRot;
    private float actualMouthRot0;

    public BeholderFamiliarEntity(EntityType<? extends BeholderFamiliarEntity> type, World worldIn) {
        super((EntityType<? extends ColoredFamiliarEntity>)type, worldIn);
        this.bigEyePos = this.bigEyeTarget;
        this.heightOffset = this.func_70681_au().nextFloat() * 5.0f;
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RayGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new EatGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public float getAnimationHeight(float partialTicks) {
        if (this.isSitting()) {
            return -0.44f;
        }
        return MathHelper.func_76134_b((float)(((float)this.field_70173_aa + this.heightOffset + partialTicks) / 5.0f)) * 0.1f;
    }

    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, ILivingEntityData pSpawnData, CompoundNBT pDataTag) {
        this.setColor();
        this.setBeard(this.func_70681_au().nextBoolean());
        this.setSpikes(this.func_70681_au().nextBoolean());
        this.setTongue(this.func_70681_au().nextDouble() < 0.1);
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasTongue()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    private void tickGlow(LivingEntity owner) {
        if (!this.isEffectEnabled(owner)) {
            return;
        }
        List nearby = owner.field_70170_p.func_175647_a(LivingEntity.class, owner.func_174813_aQ().func_186662_g(10.0), e -> !(e instanceof PlayerEntity) && e != owner && e != this && !e.func_70644_a(Effects.field_188423_x));
        if (nearby.isEmpty()) {
            return;
        }
        ((LivingEntity)nearby.get(this.func_70681_au().nextInt(nearby.size()))).func_195064_c(new EffectInstance(Effects.field_188423_x, 1200, 0, false, false));
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    public boolean hasBeard() {
        return this.hasVariant(0);
    }

    private void setBeard(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasSpikes() {
        return this.hasVariant(1);
    }

    private void setSpikes(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTongue() {
        return this.hasVariant(2);
    }

    private void setTongue(boolean b) {
        this.setVariant(2, b);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (Eye eye : this.eyes) {
                eye.tick();
            }
            this.bigEyePos0 = new Vector2f(this.bigEyePos.field_189982_i, this.bigEyePos.field_189983_j);
            if ((double)(Math.abs(this.bigEyePos.field_189982_i - this.bigEyeTarget.field_189982_i) + Math.abs(this.bigEyePos.field_189983_j - this.bigEyeTarget.field_189983_j)) < 0.05) {
                this.bigEyeTarget = new Vector2f((this.func_70681_au().nextFloat() - 0.5f) * 2.9f, (this.func_70681_au().nextFloat() - 0.5f) * 1.9f);
            }
            this.bigEyePos = this.lerpVec(0.1f, this.bigEyePos, this.bigEyeTarget);
            this.actualMouthRot0 = this.actualMouthRot;
            this.mouthRot = MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f)) * FamiliarUtil.toRads(10.0f) + FamiliarUtil.toRads(27.0f);
            if (this.eatTimer != -1) {
                ++this.eatTimer;
                if (this.eatTimer == 60) {
                    this.eatTimer = -1;
                }
                if (this.eatTimer < 50) {
                    if (this.eatTimer % 5 == 0) {
                        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187537_bA, SoundCategory.HOSTILE, this.func_70599_aP(), this.func_70647_i(), false);
                    }
                    this.mouthRot = MathHelper.func_76126_a((float)this.field_70173_aa) * FamiliarUtil.toRads(50.0f) + FamiliarUtil.toRads(20.0f);
                }
                if (this.eatTimer == 51) {
                    this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.HOSTILE, this.func_70599_aP(), 0.2f, false);
                }
            }
            this.actualMouthRot = MathHelper.func_219799_g((float)0.2f, (float)this.actualMouthRot, (float)this.mouthRot);
        } else if (this.func_70681_au().nextDouble() >= 0.98) {
            this.tickGlow(this.getFamiliarOwner());
        }
        this.field_70761_aq = this.field_70177_z;
    }

    public float getMouthRot(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.actualMouthRot0, (float)this.actualMouthRot);
    }

    public float getEatTimer(float partialTicks) {
        return ((float)this.eatTimer + partialTicks) / 60.0f;
    }

    public boolean isEating() {
        return this.eatTimer != -1;
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (this.func_70681_au().nextDouble() >= 0.98) {
            this.tickGlow(wearer);
        }
    }

    public Vector2f getBigEyePos(float partialTicks) {
        return this.lerpVec(partialTicks, this.bigEyePos0, this.bigEyePos);
    }

    public Vector2f getEyeRot(float partialTicks, int i) {
        return this.eyes[i].getEyeRot(partialTicks);
    }

    private Vector3d lerpVec(float value, Vector3d start, Vector3d stop) {
        return new Vector3d(MathHelper.func_219803_d((double)value, (double)start.field_72450_a, (double)stop.field_72450_a), MathHelper.func_219803_d((double)value, (double)start.field_72448_b, (double)stop.field_72448_b), MathHelper.func_219803_d((double)value, (double)start.field_72449_c, (double)stop.field_72449_c));
    }

    private Vector2f lerpVec(float value, Vector2f start, Vector2f stop) {
        return new Vector2f(MathHelper.func_219799_g((float)value, (float)start.field_189982_i, (float)stop.field_189982_i), MathHelper.func_219799_g((float)value, (float)start.field_189983_j, (float)stop.field_189983_j));
    }

    public void func_184609_a(Hand pHand) {
        super.func_184609_a(pHand);
        this.eatTimer = 0;
    }

    public void shootRay(List<Integer> targetIds) {
        ArrayList<Eye> eyeList = new ArrayList<Eye>();
        for (Eye e : this.eyes) {
            eyeList.add(e);
        }
        Iterator<Integer> iterator = targetIds.iterator();
        while (iterator.hasNext()) {
            Eye e;
            int id = (Integer)iterator.next();
            if (eyeList.isEmpty()) break;
            int index = this.func_70681_au().nextInt(eyeList.size());
            e = (Eye)eyeList.get(index);
            eyeList.remove(index);
            e.prepareShot(id);
        }
    }

    private static class EatGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 600;
        protected final BeholderFamiliarEntity entity;
        private int cooldown;

        private EatGoal(BeholderFamiliarEntity entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            return !this.entity.isSitting() && this.cooldown-- < 0;
        }

        public void func_75251_c() {
            this.cooldown = 600;
        }

        public void func_75249_e() {
            this.cooldown = 600;
            List foods = this.entity.field_70170_p.func_175647_a(ShubNiggurathSpawnEntity.class, this.entity.func_174813_aQ().func_186662_g(3.0), e -> e.func_70089_S());
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (!foods.isEmpty() && this.entity.isEffectEnabled(owner)) {
                Entity food = (Entity)foods.get(this.entity.func_70681_au().nextInt(foods.size()));
                food.func_70106_y();
                this.entity.func_184609_a(Hand.MAIN_HAND);
                this.entity.func_195064_c(new EffectInstance(Effects.field_76420_g, 12000, 0, false, false));
                this.entity.func_195064_c(new EffectInstance(Effects.field_76424_c, 12000, 0, false, false));
                OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.BEHOLDER_EAT);
            }
        }
    }

    private static class RayGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 100;
        protected final BeholderFamiliarEntity entity;
        private int cooldown = 100;
        private int attackTimer;
        private List<Integer> targetIds;

        private RayGoal(BeholderFamiliarEntity entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            return this.entity.getFamiliarOwner() instanceof PlayerEntity;
        }

        private List<Integer> getNearbyEnemies() {
            ArrayList<Integer> enemies = new ArrayList<Integer>();
            for (Entity entity : FamiliarUtil.getOwnerEnemies(this.entity.getFamiliarOwner(), (LivingEntity)this.entity, 100.0f)) {
                enemies.add(entity.func_145782_y());
            }
            return enemies;
        }

        protected void attack() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.BEHOLDER_RAY);
            for (int id : this.targetIds) {
                Entity e = this.entity.field_70170_p.func_73045_a(id);
                float damage = 6.0f;
                if (this.entity.func_70644_a(Effects.field_76420_g)) {
                    damage *= (float)(this.entity.func_70660_b(Effects.field_76420_g).func_76458_c() + 2);
                }
                if (e == null || !(owner instanceof PlayerEntity)) continue;
                e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)owner)), damage);
            }
        }

        public void func_75251_c() {
            this.cooldown = 100;
            this.targetIds = null;
            this.attackTimer = 0;
        }

        public void func_75246_d() {
            List<Integer> enemies = this.getNearbyEnemies();
            if (this.cooldown-- < 0 && !enemies.isEmpty()) {
                this.targetIds = enemies;
                this.cooldown = 100;
                this.attackTimer = 23;
                OccultismPackets.sendToTracking((Entity)this.entity, new MessageBeholderAttack(this.entity.func_145782_y(), this.targetIds));
            }
            if (this.targetIds != null && this.attackTimer-- < 0) {
                this.attack();
                this.targetIds = null;
            }
        }
    }

    private class Eye {
        private Vector3d lookPos0;
        private Vector3d lookPos;
        private Vector3d pos;
        private EyeTarget eyeTarget;
        private int shotTimer;

        private Eye(double x, double y, double z) {
            this.pos = new Vector3d(x, y, z);
            this.init();
        }

        public void prepareShot(int id) {
            this.shotTimer = 20;
            this.eyeTarget = new EntityEyeTarget(id);
        }

        private void init() {
            this.selectEyeTarget();
            Vector3d targetPos = this.eyeTarget.getEyeTarget();
            this.lookPos = targetPos != null ? targetPos : Vector3d.field_186680_a;
            this.lookPos0 = this.lookPos;
        }

        private void selectEyeTarget() {
            List entities = BeholderFamiliarEntity.this.field_70170_p.func_175647_a(LivingEntity.class, BeholderFamiliarEntity.this.func_174813_aQ().func_186662_g(7.0), e -> e != BeholderFamiliarEntity.this);
            this.eyeTarget = entities.isEmpty() ? new PositionEyeTarget(Vector3d.field_186680_a.func_72441_c(5.0, 0.0, 0.0).func_178785_b(BeholderFamiliarEntity.this.func_70681_au().nextFloat() * 360.0f).func_178789_a(BeholderFamiliarEntity.this.func_70681_au().nextFloat() * 360.0f).func_178787_e(BeholderFamiliarEntity.this.func_213303_ch())) : new EntityEyeTarget(((LivingEntity)entities.get(BeholderFamiliarEntity.this.func_70681_au().nextInt(entities.size()))).func_145782_y());
        }

        private boolean needNewEyeTarget() {
            Vector3d targetPos = this.eyeTarget.getEyeTarget();
            return targetPos == null || targetPos.func_72436_e(BeholderFamiliarEntity.this.func_213303_ch()) > 225.0 || BeholderFamiliarEntity.this.func_70681_au().nextDouble() < 0.01;
        }

        private void tick() {
            Vector3d targetPos;
            this.lookPos0 = this.lookPos;
            if (this.needNewEyeTarget() && this.shotTimer == 0) {
                this.selectEyeTarget();
            }
            if ((targetPos = this.eyeTarget.getEyeTarget()) != null) {
                this.lookPos = BeholderFamiliarEntity.this.lerpVec(0.2f, this.lookPos, targetPos);
            }
            if (this.shotTimer > 0) {
                --this.shotTimer;
                if (this.shotTimer < 5) {
                    this.shoot();
                }
            }
        }

        private Vector2f getEyeRot(float partialTicks) {
            float bodyRot = FamiliarUtil.toRads(MathHelper.func_219805_h((float)partialTicks, (float)BeholderFamiliarEntity.this.field_70760_ar, (float)BeholderFamiliarEntity.this.field_70761_aq));
            Vector3d direction = BeholderFamiliarEntity.this.func_242282_l(partialTicks).func_72441_c(0.0, (double)BeholderFamiliarEntity.this.getAnimationHeight(partialTicks), 0.0).func_178787_e(this.pos.func_178785_b(-bodyRot)).func_72444_a(BeholderFamiliarEntity.this.lerpVec(partialTicks, this.lookPos0, this.lookPos));
            double yRot = MathHelper.func_181159_b((double)direction.field_72449_c, (double)direction.field_72450_a) + (double)FamiliarUtil.toRads(-90.0f) - (double)bodyRot;
            double xRot = direction.func_72432_b().field_72448_b;
            return new Vector2f((float)((double)DEG_30 - (double)DEG_30 * xRot), (float)yRot);
        }

        private void shoot() {
            float bodyRot = FamiliarUtil.toRads(MathHelper.func_219805_h((float)1.0f, (float)BeholderFamiliarEntity.this.field_70760_ar, (float)BeholderFamiliarEntity.this.field_70761_aq));
            Vector2f rot = this.getEyeRot(1.0f);
            Vector3d increment = new Vector3d(0.0, 0.15, 0.0);
            Vector3d end = this.eyeTarget.getEyeTarget();
            if (end == null) {
                return;
            }
            Vector3d start = BeholderFamiliarEntity.this.func_213303_ch().func_178787_e(new Vector3d(this.pos.field_72450_a, 0.9 + (double)BeholderFamiliarEntity.this.getAnimationHeight(1.0f), this.pos.field_72449_c).func_178785_b(-bodyRot)).func_178787_e(increment);
            for (int i = 0; i < 3; ++i) {
                increment = increment.func_178789_a(-rot.field_189982_i);
                start = start.func_178787_e(increment.func_178785_b(-rot.field_189983_j - bodyRot));
            }
            Vector3d direction = start.func_72444_a(end).func_72432_b();
            AxisAlignedBB endBox = new AxisAlignedBB(end, end).func_186662_g(0.25);
            for (int i = 0; i < 150; ++i) {
                Vector3d particlePos = start.func_178787_e(direction.func_186678_a((double)i * 0.1));
                BeholderFamiliarEntity.this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(BeholderFamiliarEntity.this.getRed(), BeholderFamiliarEntity.this.getBlue(), BeholderFamiliarEntity.this.getGreen(), 1.0f), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                if (endBox.func_72326_a(new AxisAlignedBB(particlePos, particlePos).func_186662_g(0.25))) break;
            }
        }

        private class PositionEyeTarget
        extends EyeTarget {
            Vector3d position;

            private PositionEyeTarget(Vector3d position) {
                this.position = position;
            }

            @Override
            protected Vector3d getEyeTarget() {
                return this.position;
            }
        }

        private class EntityEyeTarget
        extends EyeTarget {
            int entityId;

            private EntityEyeTarget(int entityId) {
                this.entityId = entityId;
            }

            @Override
            protected Vector3d getEyeTarget() {
                Entity e = BeholderFamiliarEntity.this.field_70170_p.func_73045_a(this.entityId);
                return e == null ? null : e.func_174824_e(0.0f);
            }
        }

        private abstract class EyeTarget {
            private EyeTarget() {
            }

            protected abstract Vector3d getEyeTarget();
        }
    }
}

