/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.GoatFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.ResizableFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ChimeraFamiliarEntity
extends ResizableFamiliarEntity
implements IRideable {
    private static final UUID SPEED_BONUS = UUID.fromString("f1db15e0-174b-4534-96a3-d941cec44e55");
    private static final UUID DAMAGE_BONUS = UUID.fromString("fdaa6165-abdf-4b85-aed6-199086f6a5ee");
    public static final byte NO_ATTACKER = 0;
    public static final byte LION_ATTACKER = 1;
    public static final byte GOAT_ATTACKER = 2;
    public static final byte SNAKE_ATTACKER = 3;
    private static final byte RIDING_SIZE = 80;
    private static final double SHRINK_CHANCE = 0.005;
    private static final int JUMP_COOLDOWN = 40;
    private static final int ATTACK_TIME = 10;
    private static final DataParameter<Byte> ATTACKER = EntityDataManager.func_187226_a(ChimeraFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static Field isRiderJumping;
    private BoostHelper boost = new DummyBoostHelper();
    private int jumpTimer;
    private int goatNoseTimer = this.func_70681_au().nextInt(100);
    private int attackTimer;

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    public ChimeraFamiliarEntity(EntityType<? extends ChimeraFamiliarEntity> type, World worldIn) {
        super((EntityType<? extends ResizableFamiliarEntity>)type, worldIn);
    }

    private boolean isRiderJumping(PlayerEntity rider) {
        try {
            if (isRiderJumping == null) {
                isRiderJumping = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"field_70703_bu");
            }
            return isRiderJumping.getBoolean(rider);
        }
        catch (IllegalAccessException | IllegalArgumentException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            Occultism.LOGGER.debug("Unable to get jump field for Chimera familiar");
            return false;
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new AttackGoal(this, 10.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, ILivingEntityData pSpawnData, CompoundNBT pDataTag) {
        this.setGoat(true);
        this.setSize((byte)0);
        this.setFlaps(this.func_70681_au().nextBoolean());
        this.setRing(this.func_70681_au().nextBoolean());
        this.setBeard(this.func_70681_au().nextBoolean());
        this.setHat(this.func_70681_au().nextDouble() < 0.1);
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasHat()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKER, (Object)0);
    }

    private double getAttackBonus() {
        return MathHelper.func_219803_d((double)((double)this.getSize() / 100.0), (double)0.0, (double)3.0);
    }

    private double getSpeedBonus() {
        return MathHelper.func_219803_d((double)((double)this.getSize() / 100.0), (double)0.0, (double)0.08);
    }

    @Override
    public void setSize(byte size) {
        super.setSize(size);
        this.calcSizeModifiers();
    }

    public boolean hasFlaps() {
        return this.hasVariant(0);
    }

    public boolean hasRing() {
        return this.hasVariant(1);
    }

    public boolean hasBeard() {
        return this.hasVariant(2);
    }

    public boolean hasHat() {
        return this.hasVariant(3);
    }

    public boolean hasGoat() {
        return this.hasVariant(4);
    }

    public byte getAttacker() {
        return (Byte)this.field_70180_af.func_187225_a(ATTACKER);
    }

    private void setFlaps(boolean b) {
        this.setVariant(0, b);
    }

    private void setRing(boolean b) {
        this.setVariant(1, b);
    }

    private void setBeard(boolean b) {
        this.setVariant(2, b);
    }

    private void setHat(boolean b) {
        this.setVariant(3, b);
    }

    private void setGoat(boolean b) {
        this.setVariant(4, b);
    }

    private void setAttacker(byte b) {
        this.field_70180_af.func_187227_b(ATTACKER, (Object)b);
    }

    private void calcSizeModifiers() {
        if (this.getSize() <= 80) {
            this.func_184226_ay();
        }
        this.func_110148_a(Attributes.field_233823_f_).func_188479_b(DAMAGE_BONUS);
        this.func_110148_a(Attributes.field_233821_d_).func_188479_b(SPEED_BONUS);
        this.func_110148_a(Attributes.field_233823_f_).func_233767_b_(new AttributeModifier(DAMAGE_BONUS, "Chimera attack bonus", this.getAttackBonus(), AttributeModifier.Operation.ADDITION));
        this.func_110148_a(Attributes.field_233821_d_).func_233767_b_(new AttributeModifier(SPEED_BONUS, "Chimera speed bonus", this.getSpeedBonus(), AttributeModifier.Operation.ADDITION));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextDouble() < 0.005) {
            this.setSize((byte)(this.getSize() - 1));
        }
        if (this.jumpTimer > 0) {
            --this.jumpTimer;
        }
        --this.attackTimer;
        if (this.attackTimer == 0) {
            this.setAttacker((byte)0);
        }
        if (this.field_70170_p.field_72995_K) {
            ++this.goatNoseTimer;
            if (this.attackTimer > 0 && this.getAttacker() == 1) {
                Vector3d direction = Vector3d.func_189984_a((Vector2f)this.func_189653_aC()).func_186678_a((double)this.func_213355_cm());
                for (int i = 0; i < 5; ++i) {
                    Vector3d pos = this.func_213303_ch().func_72441_c(direction.field_72450_a + (double)(this.func_70681_au().nextFloat() - 0.5f) * 0.7, 1.0 + (double)(this.func_70681_au().nextFloat() - 0.5f) * 0.7, direction.field_72449_c + (double)(this.func_70681_au().nextFloat() - 0.5f) * 0.7);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, direction.field_72450_a * 0.1, 0.0, direction.field_72449_c * 0.1);
                }
            }
        }
    }

    public float getNoseGoatRot(float partialTicks) {
        if (this.goatNoseTimer % 200 >= 40) {
            return 0.0f;
        }
        float progress = ((float)(this.goatNoseTimer % 200) + partialTicks) / 40.0f;
        return MathHelper.func_76126_a((float)(progress * (float)Math.PI * 4.0f)) * 0.1f;
    }

    public float getAttackProgress(float partialTicks) {
        if (this.attackTimer <= 0) {
            return 0.0f;
        }
        return ((float)(10 - this.attackTimer) + partialTicks) / 10.0f;
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Food food = stack.func_77973_b().func_219967_s();
        if (this.hasGoat() && stack.func_77973_b() == Items.field_151153_ao && playerIn == this.getFamiliarOwner()) {
            if (!this.field_70170_p.field_72995_K) {
                stack.func_190918_g(1);
                this.setGoat(false);
                GoatFamiliarEntity goat = new GoatFamiliarEntity(this.field_70170_p, this.hasRing(), this.hasBeard(), this.getSize(), this.getFamiliarOwner());
                goat.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.field_70170_p.func_217376_c((Entity)goat);
                OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.GOAT_DETACH);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.getSize() < 100 && food != null && food.func_221467_c()) {
            stack.func_190918_g(1);
            this.setSize((byte)(this.getSize() + food.func_221466_a()));
            this.func_70691_i(4.0f);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!(this.isSitting() || this.func_184207_aI() || playerIn.func_226563_dT_() || this.getFamiliarOwner() != playerIn || this.getSize() <= 80)) {
            if (!this.field_70170_p.field_72995_K) {
                playerIn.func_184220_m((Entity)this);
                OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.CHIMERA_RIDE);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(playerIn, hand);
    }

    public double func_70042_X() {
        return super.func_70042_X() * 0.6;
    }

    public boolean func_82171_bF() {
        return true;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    public void func_184206_a(DataParameter<?> pKey) {
        super.func_184206_a(pKey);
        if (ATTACKER.equals(pKey)) {
            this.attackTimer = 10;
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setFlaps(compound.func_74767_n("hasFlaps"));
            this.setRing(compound.func_74767_n("hasRing"));
            if (compound.func_74764_b("hasBeard")) {
                this.setBeard(compound.func_74767_n("hasBeard"));
            }
            this.setHat(compound.func_74767_n("hasHat"));
            this.setGoat(compound.func_74767_n("hasGoat"));
        }
    }

    public void func_213352_e(Vector3d pTravelVector) {
        this.func_233622_a_((MobEntity)this, this.boost, pTravelVector);
    }

    public boolean func_184762_da() {
        return false;
    }

    protected float func_175134_bD() {
        return super.func_175134_bD() * 1.35f;
    }

    protected int func_225508_e_(float pDistance, float pDamageMultiplier) {
        return super.func_225508_e_(pDistance - 3.0f, pDamageMultiplier);
    }

    private byte[] possibleAttackers() {
        byte[] byArray;
        if (this.hasGoat()) {
            byte[] byArray2 = new byte[3];
            byArray2[0] = 1;
            byArray2[1] = 2;
            byArray = byArray2;
            byArray2[2] = 3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            byArray = byArray3;
            byArray3[1] = 3;
        }
        return byArray;
    }

    public void func_230267_a__(Vector3d pTravelVec) {
        if (this.func_184207_aI() && this.func_184179_bs() instanceof PlayerEntity) {
            PlayerEntity rider = (PlayerEntity)this.func_184179_bs();
            float forward = rider.field_191988_bg;
            float strafe = rider.field_70702_br * 0.5f;
            if (this.isRiderJumping(rider) && this.field_70122_E && this.jumpTimer <= 0) {
                this.jumpTimer = 40;
                Vector3d forwardDirection = Vector3d.func_189986_a((float)0.0f, (float)this.field_70177_z).func_186678_a(0.7);
                this.func_213317_d(this.func_213322_ci().func_72441_c(forwardDirection.field_72450_a, 0.0, forwardDirection.field_72449_c));
                this.func_70664_aZ();
            }
            if (forward < 0.0f) {
                forward *= 0.25f;
            }
            super.func_213352_e(new Vector3d((double)strafe, 0.0, (double)forward));
        } else {
            super.func_213352_e(pTravelVec);
        }
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 1.6f;
    }

    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * 0.8f;
    }

    private static class AttackGoal
    extends DevilFamiliarEntity.AttackGoal {
        ChimeraFamiliarEntity chimera;

        public AttackGoal(ChimeraFamiliarEntity chimera, float range) {
            super(chimera, range);
            this.chimera = chimera;
        }

        @Override
        protected void attack(List<LivingEntity> enemies) {
            byte attacker = this.randomAttacker();
            this.chimera.setAttacker(attacker);
            for (LivingEntity e : enemies) {
                e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.chimera.getFamiliarOwner())), (float)this.chimera.func_233637_b_(Attributes.field_233823_f_));
                switch (attacker) {
                    case 1: {
                        e.func_70015_d(4);
                        break;
                    }
                    case 2: {
                        Vector3d direction = e.func_213303_ch().func_72444_a(this.chimera.func_213303_ch());
                        e.func_233627_a_(2.0f, direction.field_72450_a, direction.field_72449_c);
                        break;
                    }
                    case 3: {
                        e.func_195064_c(new EffectInstance(Effects.field_76436_u, 200));
                    }
                }
            }
        }

        private byte randomAttacker() {
            byte[] attackers = this.chimera.possibleAttackers();
            return attackers[this.chimera.func_70681_au().nextInt(attackers.length)];
        }
    }

    private static class DummyBoostHelper
    extends BoostHelper {
        public DummyBoostHelper() {
            super(null, null, null);
        }

        public void func_233621_b_(CompoundNBT pNbt) {
        }

        public void func_233618_a_(CompoundNBT pNbt) {
        }

        public boolean func_233617_a_(Random pRand) {
            return false;
        }

        public boolean func_233620_b_() {
            return false;
        }

        public void func_233616_a_() {
        }

        public void func_233619_a_(boolean pSaddled) {
        }
    }
}

