/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class DeerFamiliarEntity
extends FamiliarEntity {
    private static final UUID SPEED_UUID = UUID.fromString("5ebf190f-3c59-41e7-9085-d14b37dfc863");
    private static final byte START_EATING = 10;
    private int eatTimer;
    private int neckRotTimer;
    private int oNeckRotTimer;

    public DeerFamiliarEntity(EntityType<? extends DeerFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new EatGrassGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && DeerFamiliarEntity.this.hasBlacksmithUpgrade();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasRedNose()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.func_225510_bt_() && this.hasRedNose()) {
            this.func_184195_f(true);
        }
        if (this.field_70170_p.field_72995_K) {
            --this.eatTimer;
            this.oNeckRotTimer = this.neckRotTimer;
            this.neckRotTimer = this.isEating() ? Math.min(this.neckRotTimer + 1, 10) : Math.max(this.neckRotTimer - 1, 0);
        }
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity owner = this.getFamiliarOwner();
            if (owner != null && this.func_70068_e((Entity)owner) > 50.0) {
                if (this.func_110148_a(Attributes.field_233821_d_).func_111127_a(SPEED_UUID) == null) {
                    this.func_110148_a(Attributes.field_233821_d_).func_233767_b_(new AttributeModifier(SPEED_UUID, "deer_speedup", 0.15, AttributeModifier.Operation.ADDITION));
                }
            } else if (this.func_110148_a(Attributes.field_233821_d_).func_111127_a(SPEED_UUID) != null) {
                this.func_110148_a(Attributes.field_233821_d_).func_188479_b(SPEED_UUID);
            }
        }
    }

    public float getNeckRot(float partialTick) {
        return 0.4f + MathHelper.func_219799_g((float)(MathHelper.func_219799_g((float)partialTick, (float)this.oNeckRotTimer, (float)this.neckRotTimer) / 10.0f), (float)0.0f, (float)1.5f);
    }

    public void func_70615_aA() {
        if (this.func_70681_au().nextDouble() < 0.25) {
            this.func_199702_a((IItemProvider)OccultismItems.DATURA_SEEDS.get(), 0);
            LivingEntity owner = this.getOwner();
            if (owner instanceof ServerPlayerEntity) {
                OccultismAdvancements.FAMILIAR.trigger((ServerPlayerEntity)owner, FamiliarTrigger.Type.DEER_POOP);
            }
        }
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new EffectInstance(Effects.field_76430_j, 300, 0, false, false));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setRedNose(this.func_70681_au().nextDouble() < 0.1);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setRedNose(compound.func_74767_n("hasRedNose"));
        }
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasRedNose() {
        return this.hasVariant(0);
    }

    private void setRedNose(boolean b) {
        this.setVariant(0, b);
    }

    public boolean isEating() {
        return this.eatTimer > 0;
    }

    private void startEating() {
        this.eatTimer = 40;
        this.neckRotTimer = 0;
    }

    public void func_70103_a(byte id) {
        if (id == 10) {
            this.startEating();
        } else {
            super.func_70103_a(id);
        }
    }
}

