/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class DevilFamiliarEntity
extends FamiliarEntity {
    private final float heightOffset = this.func_70681_au().nextFloat() * 5.0f;

    public DevilFamiliarEntity(EntityType<? extends DevilFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setLollipop(this.func_70681_au().nextDouble() < 0.1);
        this.setNose(this.func_70681_au().nextDouble() < 0.5);
        this.setEars(this.func_70681_au().nextDouble() < 0.5);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_180429_a(BlockPos pPos, BlockState pBlock) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this, 5.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasLollipop()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70613_aW() && this.field_82175_bq) {
            Vector3d direction = Vector3d.func_189984_a((Vector2f)this.func_189653_aC()).func_186678_a(0.6);
            for (int i = 0; i < 5; ++i) {
                Vector3d pos = this.func_213303_ch().func_72441_c(direction.field_72450_a + (double)(this.func_70681_au().nextFloat() - 0.5f) * 0.7, 1.5 + (double)(this.func_70681_au().nextFloat() - 0.5f) * 0.7, direction.field_72449_c + (double)(this.func_70681_au().nextFloat() - 0.5f) * 0.7);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, direction.field_72450_a * 0.25, 0.0, direction.field_72449_c * 0.25);
            }
        }
    }

    public float getAnimationHeight(float partialTicks) {
        return MathHelper.func_76134_b((float)(((float)this.field_70173_aa + this.heightOffset + partialTicks) / 3.5f));
    }

    public boolean hasLollipop() {
        return this.hasVariant(0);
    }

    private void setLollipop(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasNose() {
        return this.hasVariant(1);
    }

    private void setNose(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasEars() {
        return this.hasVariant(2);
    }

    private void setEars(boolean b) {
        this.setVariant(2, b);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setLollipop(compound.func_74767_n("hasLollipop"));
            this.setNose(compound.func_74767_n("hasNose"));
            this.setEars(compound.func_74767_n("hasEars"));
        }
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new EffectInstance(Effects.field_76426_n, 300, 0, false, false));
    }

    public static class AttackGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 100;
        protected final FamiliarEntity entity;
        private final float range;
        private int cooldown = 100;

        public AttackGoal(FamiliarEntity entity, float range) {
            this.entity = entity;
            this.range = range;
        }

        public boolean func_75250_a() {
            return this.cooldown-- < 0 && this.entity.getFamiliarOwner() instanceof PlayerEntity && !this.getNearbyEnemies().isEmpty();
        }

        private List<LivingEntity> getNearbyEnemies() {
            return FamiliarUtil.getOwnerEnemies(this.entity.getFamiliarOwner(), (LivingEntity)this.entity, this.range);
        }

        public void func_75249_e() {
            List<LivingEntity> enemies = this.getNearbyEnemies();
            if (!enemies.isEmpty() && this.entity instanceof DevilFamiliarEntity) {
                OccultismAdvancements.FAMILIAR.trigger(this.entity.getFamiliarOwner(), FamiliarTrigger.Type.DEVIL_FIRE);
            }
            this.attack(enemies);
            this.entity.func_184609_a(Hand.MAIN_HAND);
            this.cooldown = 100;
        }

        protected void attack(List<LivingEntity> enemies) {
            for (Entity entity : enemies) {
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.entity.getFamiliarOwner())), 4.0f);
            }
        }

        public void func_75251_c() {
            this.cooldown = 100;
        }
    }
}

