/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.network.MessageFairySupport;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismParticles;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FairyFamiliarEntity
extends FamiliarEntity
implements IFlyingAnimal {
    private static final DataParameter<Integer> MAGIC_TARGET = EntityDataManager.func_187226_a(FairyFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final float ANIMATION_HEIGHT_SPEED = 0.2f;
    private int saveCooldown = 0;
    private int supportAnim;

    public FairyFamiliarEntity(EntityType<? extends FairyFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WALKABLE, -1.0f);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.field_70158_ak = true;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_(Attributes.field_233822_e_, 0.4).func_233815_a_(Attributes.field_233818_a_, 18.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGIC_TARGET, (Object)-1);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasFlower()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MagicGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new SupportGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new SetAttackTargetGoal(this));
    }

    public float getSupportAnim(float partialTicks) {
        if (this.supportAnim == 0) {
            return 0.0f;
        }
        return ((float)(20 - this.supportAnim) + partialTicks) / 20.0f;
    }

    public float getAnimationHeight(float partialTicks) {
        return MathHelper.func_76134_b((float)(((float)this.field_70173_aa + partialTicks) * 0.2f)) * 0.1f + 0.12f;
    }

    public float getWingRot(float partialTicks) {
        return MathHelper.func_76134_b((float)(((float)this.field_70173_aa + partialTicks) * 0.2f * 3.0f));
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator navigator = new FlyingPathNavigator((MobEntity)this, world){

            public boolean func_188555_b(BlockPos pos) {
                BlockState state = this.field_75513_b.func_180495_p(pos);
                BlockState below = this.field_75513_b.func_180495_p(pos.func_177977_b());
                return state.func_177230_c().isAir(state, (IBlockReader)this.field_75513_b, pos) && below.func_177230_c().isAir(below, (IBlockReader)this.field_75513_b, pos.func_177977_b());
            }

            public void func_75501_e() {
                super.func_75501_e();
                BlockPos pos = this.field_75515_a.func_233580_cy_().func_177977_b();
                BlockState below = this.field_75513_b.func_180495_p(pos);
                if (below.func_177230_c().isAir(below, (IBlockReader)this.field_75513_b, pos)) {
                    if (this.field_75515_a.field_70701_bs < 0.0f) {
                        this.field_75515_a.func_70657_f(this.field_75515_a.field_70701_bs * 0.9f);
                    }
                    if (this.field_75515_a.func_213322_ci().field_72448_b < 0.0) {
                        this.field_75515_a.func_213317_d(this.field_75515_a.func_213322_ci().func_216372_d(1.0, 0.9, 1.0));
                    }
                }
            }
        };
        return navigator;
    }

    private float getPartyArmArg(float partialTicks) {
        return ((float)this.field_70173_aa + partialTicks) * 0.2f;
    }

    public float getPartyArmRotX(float partialTicks) {
        return MathHelper.func_76134_b((float)this.getPartyArmArg(partialTicks)) * FamiliarUtil.toRads(40.0f) - FamiliarUtil.toRads(90.0f);
    }

    public float getPartyArmRotY(float partialTicks) {
        return MathHelper.func_76126_a((float)this.getPartyArmArg(partialTicks)) * FamiliarUtil.toRads(40.0f);
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isSitting()) {
            this.func_213317_d(Vector3d.field_186680_a);
            this.field_70761_aq = this.field_70760_ar;
        }
        if (this.saveCooldown > 0) {
            --this.saveCooldown;
        }
        this.partyParticle();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
            this.setMagicTarget(null);
        }
        if (this.field_70170_p.field_72995_K && this.hasMagicTarget()) {
            this.field_70761_aq = 0.0f;
            this.field_70760_ar = 0.0f;
            this.magicParticle();
        }
        if (this.supportAnim > 0) {
            --this.supportAnim;
        }
    }

    private IParticleData createParticle() {
        return FamiliarUtil.isChristmas() ? (IParticleData)OccultismParticles.SNOWFLAKE.get() : new RedstoneParticleData(0.9f, 0.9f, 0.5f, 1.0f);
    }

    private void magicParticle() {
        Vector3d pos = this.getMagicPosition(1.0f);
        this.field_70170_p.func_195594_a(this.createParticle(), pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c, 0.0, 0.0, 0.0);
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (this.saveCooldown > 0) {
            --this.saveCooldown;
        }
    }

    private void partyParticle() {
        if (!this.field_70170_p.field_72995_K || !this.isPartying() || this.field_70173_aa % 2 != 0) {
            return;
        }
        Vector3d right = Vector3d.func_189986_a((float)0.0f, (float)this.field_70761_aq).func_178785_b(FamiliarUtil.toRads(-90.0f));
        Vector3d armVector = new Vector3d(0.0, -0.4, 0.0).func_178789_a(this.getPartyArmRotX(0.0f)).func_178785_b(-this.getPartyArmRotY(0.0f) + FamiliarUtil.toRads(-this.field_70761_aq + 180.0f));
        Vector3d pos = this.func_213303_ch().func_178787_e(right.func_186678_a(0.2 * (double)(this.func_184638_cS() ? -1 : 1))).func_72441_c(0.0, 0.7 + (double)this.getAnimationHeight(0.0f), 0.0).func_178787_e(armVector);
        this.field_70170_p.func_195594_a(this.createParticle(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
    }

    public Vector2f getMagicRadiusAngle(float partialTicks) {
        Entity target = this.getMagicTarget();
        if (target == null) {
            return Vector2f.field_189974_a;
        }
        float radius = target.func_213311_cf() * 1.2f;
        float angle = ((float)this.field_70173_aa + partialTicks) * 0.1f;
        return new Vector2f(radius, angle);
    }

    public Vector3d getMagicPosition(float partialTicks) {
        Entity target = this.getMagicTarget();
        if (target == null) {
            return null;
        }
        Vector3d targetPos = target.func_242282_l(partialTicks).func_72441_c(0.0, (double)(target.func_213302_cg() / 2.0f), 0.0);
        Vector2f radiusAngle = this.getMagicRadiusAngle(partialTicks);
        Vector3d offset = new Vector3d((double)(MathHelper.func_76134_b((float)radiusAngle.field_189983_j) * radiusAngle.field_189982_i), 0.0, (double)(MathHelper.func_76126_a((float)radiusAngle.field_189983_j) * radiusAngle.field_189982_i));
        return targetPos.func_178787_e(offset);
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return Collections.emptyList();
    }

    public boolean hasTeeth() {
        return this.hasVariant(0);
    }

    private void setTeeth(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasFlower() {
        return this.hasVariant(1);
    }

    private void setFlower(boolean b) {
        this.setVariant(1, b);
    }

    private void setMagicTarget(Entity entity) {
        int id = entity == null ? -1 : entity.func_145782_y();
        this.field_70180_af.func_187227_b(MAGIC_TARGET, (Object)id);
    }

    public Entity getMagicTarget() {
        int id = (Integer)this.field_70180_af.func_187225_a(MAGIC_TARGET);
        if (id < 0) {
            return null;
        }
        return this.field_70170_p.func_73045_a(id);
    }

    public boolean hasMagicTarget() {
        return this.getMagicTarget() != null;
    }

    public boolean saveFamiliar(IFamiliar familiar) {
        if (this.saveCooldown > 0 || this.isSitting()) {
            return false;
        }
        this.saveCooldown = 400;
        if (!familiar.getFamiliarEntity().field_70170_p.field_72995_K) {
            OccultismPackets.sendToTracking((Entity)this, new MessageFairySupport(this.func_145782_y(), familiar.getFamiliarEntity().func_145782_y()));
        }
        return true;
    }

    public void func_70108_f(Entity pEntity) {
        if (this.hasMagicTarget()) {
            return;
        }
        super.func_70108_f(pEntity);
    }

    protected void func_82167_n(Entity pEntity) {
        if (this.hasMagicTarget()) {
            return;
        }
        super.func_82167_n(pEntity);
    }

    protected void func_184231_a(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        if (!pSource.func_76357_e() && this.getMagicTarget() != null) {
            return false;
        }
        return super.func_70097_a(pSource, pAmount);
    }

    public boolean func_70067_L() {
        return !this.hasMagicTarget();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setTeeth(this.func_70681_au().nextBoolean());
        this.func_184641_n(this.func_70681_au().nextBoolean());
        this.setFlower(this.func_70681_au().nextDouble() < 0.1);
        return data;
    }

    public void startSupportAnimation() {
        this.supportAnim = 20;
    }

    public static class SetAttackTargetGoal
    extends TargetGoal {
        private FamiliarEntity entity;
        private int timestamp;

        public SetAttackTargetGoal(FamiliarEntity entity) {
            super((MobEntity)entity, false);
            this.entity = entity;
        }

        public boolean func_75250_a() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (owner == null) {
                return false;
            }
            if (owner.func_70068_e((Entity)this.entity) >= 400.0) {
                return false;
            }
            if (this.timestamp == owner.func_142013_aG()) {
                return false;
            }
            LivingEntity target = owner.func_110144_aD();
            return target != null && !(target instanceof PlayerEntity) && !(target instanceof IFamiliar);
        }

        public boolean func_75253_b() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            return super.func_75253_b() && owner != null && owner.func_70068_e((Entity)this.entity) < 400.0;
        }

        public void func_75249_e() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (owner == null) {
                return;
            }
            this.entity.func_70624_b(owner.func_110144_aD());
            this.timestamp = owner.func_142013_aG();
            super.func_75249_e();
        }
    }

    private static class MagicGoal
    extends MeleeAttackGoal {
        private FairyFamiliarEntity fairy;
        private int attackTimer;

        public MagicGoal(FairyFamiliarEntity fairy) {
            super((CreatureEntity)fairy, 1.8, true);
            this.fairy = fairy;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.attackTimer = 20;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.fairy.setMagicTarget(null);
        }

        protected void func_190102_a(LivingEntity pEnemy, double pDistToEnemySqr) {
            --this.attackTimer;
            double reach = this.func_179512_a(pEnemy);
            if (pDistToEnemySqr <= reach) {
                this.fairy.setMagicTarget((Entity)pEnemy);
                if (this.attackTimer <= 0) {
                    this.attackTimer = 20;
                    LivingEntity owner = this.fairy.getFamiliarOwner();
                    if (owner != null) {
                        pEnemy.func_70097_a(DamageSource.func_76358_a((LivingEntity)owner), 1.0f);
                        pEnemy.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 1));
                        List allies = this.fairy.field_70170_p.func_175647_a(LivingEntity.class, this.fairy.func_174813_aQ().func_186662_g(7.0), e -> e != this.fairy && e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == owner);
                        allies.add(owner);
                        for (LivingEntity ally : allies) {
                            ally.func_70691_i(1.0f);
                            ((ServerWorld)this.fairy.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, ally.func_226277_ct_(), ally.func_226278_cu_() + (double)ally.func_213302_cg(), ally.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                }
            } else if (pDistToEnemySqr > reach * 3.0) {
                this.fairy.setMagicTarget(null);
            }
        }

        protected double func_179512_a(LivingEntity pAttackTarget) {
            return super.func_179512_a(pAttackTarget) * 3.0;
        }
    }

    private static class SupportGoal
    extends Goal {
        private static final int DURATION = 200;
        private FairyFamiliarEntity fairy;
        private Map<UUID, Integer> cooldowns;

        private SupportGoal(FairyFamiliarEntity fairy) {
            this.fairy = fairy;
            this.cooldowns = new HashMap<UUID, Integer>();
        }

        public boolean func_75250_a() {
            return !this.fairy.isSitting() && this.fairy.getFamiliarEntity() != null;
        }

        public void func_75246_d() {
            for (Map.Entry<UUID, Integer> entry : this.cooldowns.entrySet()) {
                if (entry.getValue() <= 0) continue;
                this.cooldowns.put(entry.getKey(), entry.getValue() - 1);
            }
            if (this.fairy.field_70173_aa % 5 != 0) {
                return;
            }
            LivingEntity owner = this.fairy.getFamiliarOwner();
            if (owner == null) {
                return;
            }
            List familiars = this.fairy.field_70170_p.func_175647_a(MobEntity.class, this.fairy.func_174813_aQ().func_186662_g(10.0), e -> e != this.fairy && e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == owner);
            for (MobEntity familiar : familiars) {
                UUID id = familiar.func_110124_au();
                if (!this.cooldowns.containsKey(id)) {
                    this.cooldowns.put(id, 0);
                }
                if (this.cooldowns.get(id) != 0) continue;
                boolean gaveSupport = false;
                if (familiar.func_70027_ad() && familiar.func_195064_c(new EffectInstance(Effects.field_76426_n, 200))) {
                    gaveSupport = true;
                }
                if (familiar.func_70090_H() && familiar.func_195064_c(new EffectInstance(Effects.field_76427_o, 200))) {
                    gaveSupport = true;
                }
                if (!familiar.func_189652_ae() && familiar.field_70143_R > 3.0f && familiar.func_195064_c(new EffectInstance(Effects.field_204839_B, 200))) {
                    gaveSupport = true;
                }
                if (familiar.func_70661_as().func_226337_n_() && familiar.func_70661_as().func_208485_j().func_177951_i((Vector3i)familiar.func_233580_cy_()) > 100.0 && familiar.func_195064_c(new EffectInstance(Effects.field_76424_c, 200))) {
                    gaveSupport = true;
                }
                if (familiar.func_70643_av() != null && familiar.func_195064_c(new EffectInstance(Effects.field_76429_m, 200))) {
                    gaveSupport = true;
                }
                if (!gaveSupport) continue;
                OccultismPackets.sendToTracking((Entity)this.fairy, new MessageFairySupport(this.fairy.func_145782_y(), familiar.func_145782_y()));
                this.cooldowns.put(id, 200);
            }
        }
    }
}

