/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class FamiliarEntity
extends CreatureEntity
implements IFamiliar {
    private static final float MAX_BOOST_DISTANCE = 8.0f;
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BLACKSMITH_UPGRADE = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> VARIANTS = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private boolean partying;
    private BlockPos jukeboxPos;

    public FamiliarEntity(EntityType<? extends FamiliarEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_110163_bv();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    public void func_191987_a(BlockPos jukeboxPos, boolean partying) {
        this.jukeboxPos = jukeboxPos;
        this.partying = partying;
    }

    public boolean isPartying() {
        return this.partying;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(BLACKSMITH_UPGRADE, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(VARIANTS, (Object)0);
    }

    public boolean hasBlacksmithUpgrade() {
        return (Boolean)this.field_70180_af.func_187225_a(BLACKSMITH_UPGRADE);
    }

    private void setBlacksmithUpgrade(boolean b) {
        this.field_70180_af.func_187227_b(BLACKSMITH_UPGRADE, (Object)b);
    }

    @Override
    public void blacksmithUpgrade() {
        this.setBlacksmithUpgrade(true);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_70636_d() {
        LivingEntity owner;
        this.func_82168_bl();
        if (this.jukeboxPos == null || !this.jukeboxPos.func_218137_a((IPosition)this.func_213303_ch(), 3.5) || !this.field_70170_p.func_180495_p(this.jukeboxPos).func_203425_a(Blocks.field_150421_aI)) {
            this.partying = false;
            this.jukeboxPos = null;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 10L == 0L && (owner = this.getFamiliarOwner()) != null && this.func_70032_d((Entity)owner) < 8.0f && this.isEffectEnabled(this.getFamiliarOwner())) {
            for (EffectInstance effect : this.getFamiliarEffects()) {
                owner.func_195064_c(effect);
            }
        }
        super.func_70636_d();
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerId();
        return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() == OccultismItems.FAMILIAR_RING.get()) {
            return stack.func_111282_a_(playerIn, (LivingEntity)this, hand);
        }
        if (stack.func_77973_b() == OccultismItems.DEBUG_WAND.get()) {
            this.setOwnerId(playerIn.func_110124_au());
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.field_70170_p.field_72995_K && this.getFamiliarOwner() == playerIn) {
            this.setSitting(!this.isSitting());
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    @Override
    public LivingEntity getFamiliarOwner() {
        return this.getOwner();
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        this.setOwnerId(owner.func_110124_au());
    }

    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    private void setOwnerId(UUID id) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(id));
    }

    @Override
    public Entity getFamiliarEntity() {
        return this;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("owner")) {
            this.setOwnerId(compound.func_186857_a("owner"));
        }
        if (compound.func_74764_b("isSitting")) {
            this.setSitting(compound.func_74767_n("isSitting"));
        }
        this.setBlacksmithUpgrade(compound.func_74767_n("hasBlacksmithUpgrade"));
        this.field_70180_af.func_187227_b(VARIANTS, (Object)compound.func_74771_c("variants"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() != null) {
            compound.func_186854_a("owner", this.getOwnerId());
        }
        compound.func_74757_a("isSitting", this.isSitting());
        compound.func_74757_a("hasBlacksmithUpgrade", this.hasBlacksmithUpgrade());
        compound.func_74774_a("variants", ((Byte)this.field_70180_af.func_187225_a(VARIANTS)).byteValue());
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    protected void setSitting(boolean b) {
        this.field_70180_af.func_187227_b(SITTING, (Object)b);
    }

    protected void setVariant(int offset, boolean b) {
        if (b) {
            this.field_70180_af.func_187227_b(VARIANTS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(VARIANTS) | 1 << offset)));
        } else {
            this.field_70180_af.func_187227_b(VARIANTS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(VARIANTS) & ~(1 << offset))));
        }
    }

    protected boolean hasVariant(int offset) {
        return ((Byte)this.field_70180_af.func_187225_a(VARIANTS) >> offset & 1) == 1;
    }

    protected class SitGoal
    extends Goal {
        private final FamiliarEntity entity;

        public SitGoal(FamiliarEntity entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.entity.func_203005_aq() && this.entity.getFamiliarOwner() != null && this.entity.isSitting();
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_184210_p();
            this.entity.func_184226_ay();
        }

        public void func_75251_c() {
            this.entity.setSitting(false);
        }
    }

    protected static class FollowOwnerGoal
    extends Goal {
        private static final int TELEPORT_ATTEMPTS = 10;
        private final double speed;
        private final float maxDist;
        private final float minDist;
        protected FamiliarEntity entity;
        private int cooldown;
        private LivingEntity owner;

        public FollowOwnerGoal(FamiliarEntity entity, double speed, float minDist, float maxDist) {
            this.entity = entity;
            this.speed = speed;
            this.minDist = minDist * minDist;
            this.maxDist = maxDist * maxDist;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean shouldFollow(double distance) {
            return this.owner != null && !this.owner.func_175149_v() && this.entity.func_70068_e((Entity)this.owner) > distance;
        }

        public boolean func_75250_a() {
            this.owner = this.entity.getFamiliarOwner();
            return this.shouldFollow(this.minDist);
        }

        public boolean func_75253_b() {
            return this.shouldFollow(this.maxDist);
        }

        public void func_75249_e() {
            this.cooldown = 0;
        }

        public void func_75251_c() {
            this.owner = null;
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.entity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.entity.func_70646_bf());
            if (--this.cooldown < 0) {
                this.cooldown = 10;
                if (!this.entity.func_110167_bD() && !this.entity.func_184218_aH()) {
                    if (this.entity.func_70068_e((Entity)this.owner) >= 150.0 || this.shouldTeleport(this.owner)) {
                        this.tryTeleport();
                    } else {
                        this.entity.func_70661_as().func_75497_a((Entity)this.owner, this.speed);
                    }
                }
            }
        }

        protected boolean shouldTeleport(LivingEntity owner) {
            return false;
        }

        private void tryTeleport() {
            for (int i = 0; i < 10; ++i) {
                if (!this.tryTeleport(this.randomNearby(this.owner.func_233580_cy_()))) continue;
                return;
            }
        }

        private boolean tryTeleport(BlockPos pos) {
            boolean walkable = PathNodeType.WALKABLE == WalkNodeProcessor.func_237231_a_((IBlockReader)this.entity.field_70170_p, (BlockPos.Mutable)pos.func_239590_i_());
            boolean noCollision = this.entity.field_70170_p.func_226665_a__((Entity)this.entity, this.entity.func_174813_aQ().func_186670_a(pos.func_177973_b((Vector3i)this.entity.func_233580_cy_())));
            if (walkable && noCollision) {
                this.entity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.entity.field_70177_z, this.entity.field_70125_A);
                this.entity.field_70699_by.func_75499_g();
                return true;
            }
            return false;
        }

        private BlockPos randomNearby(BlockPos pos) {
            Random rand = this.entity.func_70681_au();
            return pos.func_177963_a(MathHelper.func_82716_a((Random)rand, (double)-3.0, (double)3.0), MathHelper.func_82716_a((Random)rand, (double)-1.0, (double)1.0), MathHelper.func_82716_a((Random)rand, (double)-3.0, (double)3.0));
        }
    }
}

