/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.ResizableFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.ShubNiggurathFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.Tags;

public class GoatFamiliarEntity
extends ResizableFamiliarEntity {
    private int shakeHeadTimer;

    public GoatFamiliarEntity(EntityType<? extends GoatFamiliarEntity> type, World worldIn) {
        super((EntityType<? extends ResizableFamiliarEntity>)type, worldIn);
    }

    public GoatFamiliarEntity(World worldIn, boolean hasRing, boolean hasBeard, byte size, LivingEntity owner) {
        this((EntityType<? extends GoatFamiliarEntity>)((EntityType)OccultismEntities.GOAT_FAMILIAR.get()), worldIn);
        this.setRing(hasRing);
        this.setBeard(hasBeard);
        this.setSize(size);
        this.setFamiliarOwner(owner);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        if (super.func_70097_a(pSource, pAmount)) {
            if (pSource.func_76346_g() != null) {
                GoatFamiliarEntity.ringBell(this);
            }
            return true;
        }
        return false;
    }

    public static void ringBell(FamiliarEntity entity) {
        LivingEntity owner = entity.getFamiliarOwner();
        if (owner == null || !entity.hasBlacksmithUpgrade()) {
            return;
        }
        entity.func_184185_a(SoundEvents.field_219603_Y, 1.0f, 1.0f);
        for (MobEntity e2 : entity.field_70170_p.func_175647_a(MobEntity.class, entity.func_174813_aQ().func_186662_g(30.0), e -> e.func_70089_S() && e.getClassification(false) == EntityClassification.MONSTER)) {
            e2.func_70624_b(owner);
        }
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setRing(compound.func_74767_n("hasRing"));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            --this.shakeHeadTimer;
        }
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasRing() {
        return this.hasVariant(0);
    }

    private void setRing(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasBeard() {
        return this.hasVariant(1);
    }

    private void setBeard(boolean b) {
        this.setVariant(1, b);
    }

    public boolean isBlack() {
        return this.hasVariant(2);
    }

    private void setBlack(boolean b) {
        this.setVariant(2, b);
    }

    public boolean hasRedEyes() {
        return this.hasVariant(3);
    }

    private void setRedEyes(boolean b) {
        this.setVariant(3, b);
    }

    public boolean hasEvilHorns() {
        return this.hasVariant(4);
    }

    private void setEvilHorns(boolean b) {
        this.setVariant(4, b);
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        boolean isInForest;
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        boolean bl = isInForest = this.isInForest((Entity)playerIn) || this.isInForest((Entity)this);
        if (this.isTransformItem(item) && playerIn == this.getFamiliarOwner()) {
            if (isInForest) {
                if (!this.field_70170_p.field_72995_K) {
                    stack.func_190918_g(1);
                }
                if (item.func_206844_a((ITag)Tags.Items.DYES_BLACK)) {
                    this.setBlack(true);
                } else if (item == Items.field_151061_bv) {
                    this.setRedEyes(true);
                } else if (item == Items.field_151145_ak) {
                    this.setEvilHorns(true);
                }
                if (this.shouldTransform()) {
                    OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.SHUB_NIGGURATH_SUMMON);
                    this.transform();
                }
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            this.shakeHeadTimer = 20;
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(playerIn, hand);
    }

    private void transform() {
        if (this.field_70170_p.field_72995_K) {
            float scale = this.func_213355_cm();
            for (int i = 0; i < 30; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226282_d_(scale), this.func_226279_cv_() * (double)scale, this.func_226287_g_(scale), 0.0, 0.0, 0.0);
            }
        } else {
            ShubNiggurathFamiliarEntity shubNiggurath = new ShubNiggurathFamiliarEntity(this.field_70170_p, this);
            this.field_70170_p.func_217376_c((Entity)shubNiggurath);
            this.func_70106_y();
        }
    }

    boolean isTransformItem(Item item) {
        return item.func_206844_a((ITag)Tags.Items.DYES_BLACK) && !this.isBlack() || item == Items.field_151145_ak && !this.hasEvilHorns() || item == Items.field_151061_bv && !this.hasRedEyes();
    }

    boolean shouldTransform() {
        return this.isBlack() && this.hasRedEyes() && this.hasEvilHorns();
    }

    private boolean isInForest(Entity entity) {
        return this.field_70170_p.func_226691_t_(entity.func_233580_cy_()).func_201856_r() == Biome.Category.FOREST;
    }

    public float getNeckYRot(float pPartialTick) {
        if (this.shakeHeadTimer <= 0) {
            return 0.0f;
        }
        return MathHelper.func_76126_a((float)(((float)this.shakeHeadTimer - pPartialTick) / 20.0f * (float)Math.PI * 5.0f)) * (float)Math.toRadians(30.0);
    }
}

