/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.ColoredFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class GuardianFamiliarEntity
extends ColoredFamiliarEntity {
    private static final byte MAX_LIVES = 5;
    public static final byte UNDAMAGED = 5;
    public static final byte ONE_ARMED = 4;
    public static final byte ONE_LEGGED = 3;
    public static final byte FLOATING = 2;
    public static final byte DEATHS_DOOR = 1;
    public static final byte DEAD = 0;
    private static final DataParameter<Byte> LIVES = EntityDataManager.func_187226_a(GuardianFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private byte lives0 = (byte)-1;
    private int particleTimer;

    public GuardianFamiliarEntity(EntityType<? extends GuardianFamiliarEntity> type, World worldIn) {
        super((EntityType<? extends ColoredFamiliarEntity>)type, worldIn);
    }

    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, ILivingEntityData pSpawnData, CompoundNBT pDataTag) {
        this.setColor();
        this.setTree(this.func_70681_au().nextDouble() < 0.1);
        this.setBird(this.func_70681_au().nextDouble() < 0.5);
        this.setTools(this.func_70681_au().nextDouble() < 0.5);
        this.setLives((byte)(this.func_70681_au().nextInt(5) + 1));
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean hasLegs() {
        return this.getLives() > 2;
    }

    protected void func_180429_a(BlockPos pPos, BlockState pBlock) {
        if (!this.hasLegs()) {
            return;
        }
        super.func_180429_a(pPos, pBlock);
    }

    public float getAnimationHeight(float partialTicks) {
        return this.hasLegs() ? 0.0f : MathHelper.func_76134_b((float)(((float)this.field_70173_aa + partialTicks) / 5.0f));
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade() && this.getLives() != 5;
    }

    @Override
    public void blacksmithUpgrade() {
        super.blacksmithUpgrade();
        this.setLives((byte)(this.getLives() + 1));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasTree()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIVES, (Object)0);
    }

    public boolean sacrifice() {
        boolean success;
        byte lives = this.getLives();
        boolean bl = success = lives > 0;
        if (lives == 1) {
            OccultismAdvancements.FAMILIAR.trigger(this.getFamiliarOwner(), FamiliarTrigger.Type.GUARDIAN_ULTIMATE_SACRIFICE);
        }
        this.setLives((byte)(lives - 1));
        return success;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getLives() <= 0 && !this.field_70170_p.field_72995_K) {
            this.func_174812_G();
        }
        if (this.lives0 != -1 && this.lives0 > this.getLives()) {
            this.particleTimer = 30;
            this.func_184185_a(SoundEvents.field_187543_bD, this.func_70599_aP(), this.func_70647_i());
        }
        this.lives0 = this.getLives();
        if (this.field_70170_p.field_72995_K && this.particleTimer-- > 0) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150348_b.func_176223_P()).setPos(this.func_233580_cy_()), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    public boolean hasTree() {
        return this.hasVariant(0);
    }

    private void setTree(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasBird() {
        return this.hasVariant(1);
    }

    private void setBird(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTools() {
        return this.hasVariant(2);
    }

    private void setTools(boolean b) {
        this.setVariant(2, b);
    }

    public byte getLives() {
        return (Byte)this.field_70180_af.func_187225_a(LIVES);
    }

    private void setLives(byte b) {
        if (b < 0 || b > 5) {
            return;
        }
        this.field_70180_af.func_187227_b(LIVES, (Object)b);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("lives", this.getLives());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setTree(compound.func_74767_n("hasTree"));
            this.setBird(compound.func_74767_n("hasBird"));
            this.setTools(compound.func_74767_n("hasTools"));
        }
        this.setLives(compound.func_74771_c("lives"));
        if (compound.func_74767_n("for_patchouli")) {
            this.setLives((byte)5);
            this.setColor();
        }
    }
}

