/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FairyFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class MummyFamiliarEntity
extends FamiliarEntity {
    private static final UUID DAMAGE_BONUS = UUID.fromString("6aa62086-7009-402b-9c13-c2de74bf077d");
    private static final int MAX_FIGHT_TIMER = 5;
    private int fightPose;
    private int fightTimer;
    private Vector3d capowPos;
    private Vector3d capowOffset;
    private Vector3d capowOffset0;

    public MummyFamiliarEntity(EntityType<? extends MummyFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
        this.capowOffset = this.capowOffset0 = Vector3d.field_186680_a;
        this.capowPos = this.capowOffset0;
        this.fightPose = -1;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_(Attributes.field_233818_a_, 18.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233819_b_, 30.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setCrown(this.func_70681_au().nextDouble() < 0.1);
        this.setTooth(this.func_70681_au().nextBoolean());
        this.setHeka(this.func_70681_au().nextBoolean());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.25, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new FairyFamiliarEntity.SetAttackTargetGoal(this));
    }

    public void func_226292_a_(Hand pHand, boolean pUpdateSelf) {
        super.func_226292_a_(pHand, pUpdateSelf);
        this.fightPose = 0;
        this.fightTimer = 0;
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasCrown()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new EffectInstance((Effect)OccultismEffects.MUMMY_DODGE.get(), 300, 0, false, false));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.fightPose != -1) {
            this.capowOffset0 = this.capowOffset;
            if (this.fightTimer++ == 5) {
                this.fightTimer = 0;
                ++this.fightPose;
                if (this.fightPose == 3) {
                    this.fightPose = -1;
                }
                this.capowPos = new Vector3d(this.randNum(2.0), -this.field_70146_Z.nextDouble(), this.randNum(2.0));
            }
            this.capowOffset = new Vector3d(this.randNum(0.1), this.randNum(0.1), this.randNum(0.1));
        }
    }

    private double randNum(double size) {
        return (this.field_70146_Z.nextDouble() - 0.5) * size;
    }

    public float getCapowAlpha(float partialTicks) {
        return ((float)(5 - this.fightTimer) - partialTicks) / 5.0f;
    }

    public Vector3d getCapowPosition(float partialTicks) {
        return this.capowPos.func_178787_e(this.capowOffset0.func_178787_e(this.capowOffset0.func_178788_d(this.capowOffset).func_186678_a((double)partialTicks)));
    }

    public int getFightPose() {
        return this.fightPose;
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    public void blacksmithUpgrade() {
        super.blacksmithUpgrade();
        AttributeModifier damage = new AttributeModifier(DAMAGE_BONUS, "Mummy attack bonus", 3.0, AttributeModifier.Operation.ADDITION);
        if (!this.func_110148_a(Attributes.field_233823_f_).func_180374_a(damage)) {
            this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(damage);
        }
    }

    public boolean hasCrown() {
        return this.hasVariant(0);
    }

    private void setCrown(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasHeka() {
        return this.hasVariant(1);
    }

    private void setHeka(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTooth() {
        return this.hasVariant(2);
    }

    private void setTooth(boolean b) {
        this.setVariant(2, b);
    }
}

