/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ShubNiggurathSpawnEntity
extends CreatureEntity {
    private static final int EYE_COUNT = 4;
    private static final int LIFE_TICKS_MAX = 400;
    private int[] eyeBlinkTimers = new int[4];
    private int lifeTicks = 400;
    private UUID creatorId;

    public ShubNiggurathSpawnEntity(EntityType<? extends ShubNiggurathSpawnEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ShubNiggurathSpawnEntity(World worldIn, LivingEntity creator) {
        this((EntityType<? extends ShubNiggurathSpawnEntity>)((EntityType)OccultismEntities.SHUB_NIGGURATH_SPAWN.get()), worldIn);
        this.creatorId = creator.func_110124_au();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveToTargetGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new FindEnemiesGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindCreatorGoal(this));
    }

    public boolean isBlinking(int eye) {
        return this.eyeBlinkTimers[eye] < 3;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.lifeTicks-- < 0) {
                this.explode();
            }
            if (this.lifeTicks % 10 == 0 && !FamiliarUtil.getOwnerEnemies(this.getCreatorOwner(), (LivingEntity)this, 10.0f).isEmpty()) {
                this.explode();
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                int n = i;
                this.eyeBlinkTimers[n] = this.eyeBlinkTimers[n] - 1;
                if (this.eyeBlinkTimers[i] >= 0) continue;
                this.eyeBlinkTimers[i] = this.func_70681_au().nextInt(100) + 50;
            }
        }
    }

    private void explode() {
        if (!this.func_70089_S()) {
            return;
        }
        float damage = (float)this.func_233637_b_(Attributes.field_233823_f_);
        LivingEntity owner = this.getCreatorOwner();
        List<LivingEntity> enemies = FamiliarUtil.getOwnerEnemies(owner, (LivingEntity)this, 10.0f);
        for (LivingEntity e : enemies) {
            e.func_70097_a(owner == null ? DamageSource.field_76377_j : DamageSource.func_76358_a((LivingEntity)owner), damage);
        }
        if (!enemies.isEmpty()) {
            OccultismAdvancements.FAMILIAR.trigger(this.getCreatorOwner(), FamiliarTrigger.Type.SHUB_NIGGURATH_SPAWN);
        }
        this.func_174812_G();
    }

    private LivingEntity getCreator() {
        if (this.creatorId == null) {
            return null;
        }
        Entity creator = ((ServerWorld)this.field_70170_p).func_217461_a(this.creatorId);
        if (!(creator instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)creator;
    }

    private LivingEntity getCreatorOwner() {
        LivingEntity creator = this.getCreator();
        if (creator instanceof IFamiliar) {
            return ((IFamiliar)creator).getFamiliarOwner();
        }
        return creator;
    }

    public void func_70645_a(DamageSource pCause) {
        super.func_70645_a(pCause);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(0.5f, 0.0f, 0.0f, 1.0f), this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), 0.0, 1.0, 0.0);
            }
        }
    }

    public void func_213281_b(CompoundNBT pCompound) {
        super.func_213281_b(pCompound);
        pCompound.func_74768_a("lifeTicks", this.lifeTicks);
        if (this.creatorId != null) {
            pCompound.func_186854_a("creatorId", this.creatorId);
        }
    }

    public void func_70037_a(CompoundNBT pCompound) {
        super.func_70037_a(pCompound);
        if (pCompound.func_74764_b("lifeTicks")) {
            this.lifeTicks = pCompound.func_74762_e("lifeTicks");
        }
        if (pCompound.func_186855_b("creatorId")) {
            this.creatorId = pCompound.func_186857_a("creatorId");
        }
    }

    private static class MoveToTargetGoal
    extends Goal {
        private ShubNiggurathSpawnEntity entity;
        private int timer;

        private MoveToTargetGoal(ShubNiggurathSpawnEntity entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            LivingEntity target = this.entity.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            if (this.timer-- < 0) {
                this.timer = 20;
                LivingEntity target = this.entity.func_70638_az();
                if (target != null) {
                    this.entity.func_70661_as().func_75497_a((Entity)target, 1.0);
                }
            }
        }
    }

    private static class FindEnemiesGoal
    extends FindTargetGoal {
        private FindEnemiesGoal(ShubNiggurathSpawnEntity entity) {
            super(entity);
        }

        @Override
        protected LivingEntity findTarget() {
            List<LivingEntity> enemies = FamiliarUtil.getOwnerEnemies(this.entity.getCreatorOwner(), (LivingEntity)this.entity, 30.0f);
            if (!enemies.isEmpty()) {
                return enemies.get(0);
            }
            return null;
        }
    }

    private static class FindCreatorGoal
    extends FindTargetGoal {
        private FindCreatorGoal(ShubNiggurathSpawnEntity entity) {
            super(entity);
        }

        @Override
        protected LivingEntity findTarget() {
            return this.entity.getCreator();
        }
    }

    private static abstract class FindTargetGoal
    extends TargetGoal {
        protected ShubNiggurathSpawnEntity entity;

        private FindTargetGoal(ShubNiggurathSpawnEntity entity) {
            super((MobEntity)entity, false);
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        }

        protected abstract LivingEntity findTarget();

        public void func_75249_e() {
            LivingEntity target = this.findTarget();
            if (target != null) {
                this.entity.func_70624_b(target);
            }
            super.func_75249_e();
        }

        public boolean func_75250_a() {
            return this.findTarget() != null;
        }
    }
}

