/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.ai.PausableGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.github.klikli_dev.occultism.util.StorageUtil;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ExtractItemsGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;

    public ExtractItemsGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.func_213303_ch(), Math3DUtil.center(this.targetBlock));
        return this.targetBlock.func_177972_a(Direction.func_176733_a((double)angle).func_176734_d());
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity.func_70638_az() != null) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return !this.isPaused() && this.targetBlock != null;
    }

    @Override
    public boolean func_75253_b() {
        return !this.isPaused() && this.targetBlock != null && !this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            if (this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
                TileEntity tileEntity = this.entity.field_70170_p.func_175625_s(this.targetBlock);
                float accessDistance = 1.86f;
                double distance = this.entity.func_213303_ch().func_72438_d(Math3DUtil.center(this.targetBlock));
                if (distance < 2.5 && distance >= (double)accessDistance && this.canSeeTarget() && tileEntity instanceof IInventory) {
                    this.toggleChest((IInventory)tileEntity, true);
                }
                if (distance < (double)accessDistance) {
                    this.entity.func_70661_as().func_75499_g();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_179680_a(moveTarget, 0), 1.0);
                }
                if (distance < 1.86 && this.canSeeTarget()) {
                    ItemStack remaining;
                    ItemStack toExtract;
                    LazyOptional handlerCapability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getExtractFacing());
                    if (!handlerCapability.isPresent()) {
                        this.resetTarget();
                        return;
                    }
                    IItemHandler tileHandler = (IItemHandler)handlerCapability.orElseThrow(ItemHandlerMissingException::new);
                    IItemHandler entityHandler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElseThrow(ItemHandlerMissingException::new);
                    int slot = StorageUtil.getFirstMatchingSlot(tileHandler, (IItemHandler)this.entity.getFilterItems().orElseThrow(ItemHandlerMissingException::new), this.entity.getTagFilter(), this.entity.isFilterBlacklist());
                    if (slot >= 0 && !(toExtract = tileHandler.extractItem(slot, Integer.MAX_VALUE, true).func_77946_l()).func_190926_b() && (remaining = ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)toExtract, (boolean)true)).func_190916_E() < toExtract.func_190916_E()) {
                        ItemStack extracted = tileHandler.extractItem(slot, toExtract.func_190916_E() - remaining.func_190916_E(), false);
                        ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)extracted, (boolean)false);
                    }
                    if (tileEntity instanceof IInventory) {
                        this.toggleChest((IInventory)tileEntity, false);
                    }
                }
            } else {
                this.resetTarget();
            }
        }
    }

    public boolean canSeeTarget() {
        RayTraceContext context = new RayTraceContext(this.entity.func_213303_ch(), Math3DUtil.center(this.targetBlock), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity);
        BlockRayTraceResult result = this.entity.field_70170_p.func_217299_a(context);
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            BlockPos sidePos = result.func_216350_a();
            BlockPos pos = new BlockPos(result.func_216347_e());
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    public void toggleChest(IInventory tileEntity, boolean open) {
        if (tileEntity instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)tileEntity;
            if (open) {
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_195044_w().func_177230_c(), 1, 1);
            } else {
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_195044_w().func_177230_c(), 1, 0);
            }
        }
    }

    private void resetTarget() {
        Optional<BlockPos> targetPos = this.entity.getExtractPosition();
        targetPos.ifPresent(pos -> {
            this.targetBlock = pos;
            TileEntity tileEntity = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            if (tileEntity == null || !tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getExtractFacing()).isPresent()) {
                this.entity.setExtractPosition(null);
            }
        });
    }
}

