/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.LumberjackJob;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;

public class ReplantSaplingGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos moveTarget = null;

    public ReplantSaplingGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.func_213303_ch(), Math3DUtil.center(this.moveTarget));
        return this.moveTarget.func_177972_a(Direction.func_176733_a((double)angle).func_176734_d());
    }

    public boolean func_75250_a() {
        if (!ItemTags.field_200037_g.func_230235_a_((Object)this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b())) {
            return false;
        }
        if (!this.entity.getJob().map(j -> (LumberjackJob)j).map(j -> j.getLastFelledTree() != null).orElse(false).booleanValue()) {
            return false;
        }
        this.resetTarget();
        return this.moveTarget != null;
    }

    public boolean func_75253_b() {
        return this.moveTarget != null && !ItemTags.field_200037_g.func_230235_a_((Object)this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b()) && this.entity.getJob().map(j -> (LumberjackJob)j).map(j -> j.getLastFelledTree() != null).orElse(false) == false;
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.moveTarget != null) {
            float accessDistance = 4.5f;
            double distance = this.entity.func_213303_ch().func_72438_d(Math3DUtil.center(this.moveTarget));
            if (distance < (double)accessDistance) {
                this.entity.func_70661_as().func_75499_g();
                this.entity.getJob().map(j -> (LumberjackJob)j).map(LumberjackJob::getLastFelledTree).ifPresent(lastFelledTree -> {
                    ItemStack sapling;
                    if (this.entity.field_70170_p.func_175623_d(lastFelledTree) && (sapling = this.entity.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof BlockItem) {
                        BlockItem saplingBlockItem = (BlockItem)sapling.func_77973_b();
                        this.entity.field_70170_p.func_175656_a(lastFelledTree, saplingBlockItem.func_179223_d().func_176223_P());
                        sapling.func_190918_g(1);
                    }
                });
                this.entity.getJob().map(j -> (LumberjackJob)j).ifPresent(j -> j.setLastFelledTree(null));
            } else {
                BlockPos moveTarget = this.getMoveTarget();
                this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_179680_a(moveTarget, 0), 1.0);
            }
        } else {
            this.resetTarget();
        }
    }

    private void resetTarget() {
        this.moveTarget = null;
        this.entity.getJob().map(j -> (LumberjackJob)j).map(LumberjackJob::getLastFelledTree).ifPresent(t -> {
            this.moveTarget = t;
        });
    }
}

