/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.spirit;

import com.github.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.github.klikli_dev.occultism.common.job.TransportItemsJob;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BookOfCallingTransportItems
extends BookOfCallingItem {
    public BookOfCallingTransportItems(Item.Properties properties, String translationKeyBase) {
        super(properties, translationKeyBase, spirit -> spirit.getJob().orElse(null) instanceof TransportItemsJob);
    }

    @Override
    public BookOfCallingItem.IItemModeSubset<?> getItemModeSubset(ItemStack stack) {
        ItemModeSubset subset = ItemModeSubset.get(BookOfCallingItem.ItemMode.get(this.getItemMode(stack)));
        return subset != null ? subset : ItemModeSubset.SET_DEPOSIT;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        BlockPos extract = ItemNBTUtil.getExtractPosition(stack);
        if (extract != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.getTranslationKeyBase() + ".tooltip.extract", new Object[]{extract.toString()}));
        }
        BlockPos deposit = ItemNBTUtil.getDepositPosition(stack);
        String depositName = ItemNBTUtil.getDepositEntityName(stack);
        if (deposit != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.getTranslationKeyBase() + ".tooltip.deposit", new Object[]{deposit.toString()}));
        } else if (depositName != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.getTranslationKeyBase() + ".tooltip.deposit_entity", new Object[]{TextUtil.formatDemonName(depositName)}));
        }
    }

    public static enum ItemModeSubset implements BookOfCallingItem.IItemModeSubset<ItemModeSubset>
    {
        SET_EXTRACT(BookOfCallingItem.ItemMode.SET_EXTRACT),
        SET_DEPOSIT(BookOfCallingItem.ItemMode.SET_DEPOSIT);

        private static final Map<BookOfCallingItem.ItemMode, ItemModeSubset> lookup;
        private final BookOfCallingItem.ItemMode itemMode;

        private ItemModeSubset(BookOfCallingItem.ItemMode itemMode) {
            this.itemMode = itemMode;
        }

        public static ItemModeSubset get(BookOfCallingItem.ItemMode value) {
            return lookup.get(value);
        }

        @Override
        public BookOfCallingItem.ItemMode getItemMode() {
            return this.itemMode;
        }

        @Override
        public ItemModeSubset next() {
            return ItemModeSubset.values()[(this.ordinal() + 1) % ItemModeSubset.values().length];
        }

        static {
            lookup = new HashMap<BookOfCallingItem.ItemMode, ItemModeSubset>();
            for (ItemModeSubset subset : ItemModeSubset.values()) {
                lookup.put(subset.getItemMode(), subset);
            }
        }
    }
}

