/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.spirit;

import com.github.klikli_dev.occultism.common.tile.DimensionalMineshaftTileEntity;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MinerSpiritItem
extends Item {
    protected static Field maxDamageField = ObfuscationReflectionHelper.findField(Item.class, (String)"field_77699_b");
    private final Supplier<Integer> maxMiningTime;
    private final Supplier<Integer> rollsPerOperation;
    private final Supplier<Integer> maxDamage;
    private boolean hasInitializedMaxDamage;

    public MinerSpiritItem(Item.Properties properties, Supplier<Integer> maxMiningTime, Supplier<Integer> rollsPerOperation, Supplier<Integer> maxDamage) {
        super(properties);
        this.maxMiningTime = maxMiningTime;
        this.rollsPerOperation = rollsPerOperation;
        this.maxDamage = maxDamage;
        this.hasInitializedMaxDamage = false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip", new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!this.hasInitializedMaxDamage) {
            this.hasInitializedMaxDamage = true;
            try {
                maxDamageField.setInt((Object)this, this.maxDamage.get());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return super.getDurabilityForDisplay(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (!this.hasInitializedMaxDamage) {
            this.hasInitializedMaxDamage = true;
            try {
                maxDamageField.setInt((Object)this, this.maxDamage.get());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        stack.func_196082_o().func_74768_a("maxMiningTime", this.maxMiningTime.get().intValue());
        stack.func_196082_o().func_74768_a(DimensionalMineshaftTileEntity.ROLLS_PER_OPERATION_TAG, this.rollsPerOperation.get().intValue());
    }
}

