/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class FamiliarRingItem
extends Item {
    public FamiliarRingItem(Item.Properties properties) {
        super(properties);
    }

    private static Curio getCurio(ItemStack stack) {
        ICurio curio = (ICurio)stack.getCapability(CuriosCapability.ITEM).orElse(null);
        if (curio != null && curio instanceof Curio) {
            return (Curio)curio;
        }
        return null;
    }

    public static IFamiliar getFamiliar(ItemStack stack, World world) {
        Curio curio = FamiliarRingItem.getCurio(stack);
        return curio == null ? null : curio.getFamiliar(world);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        CompoundNBT tag = stack.func_77978_p();
        if (!playerIn.field_70170_p.field_72995_K && tag != null && tag.func_74763_f("occupiedTime") < worldIn.func_82737_E() + 5L && FamiliarRingItem.getCurio(stack).releaseFamiliar(playerIn, worldIn)) {
            tag.func_74757_a("occupied", false);
            return ActionResult.func_233538_a_((Object)stack, (boolean)playerIn.field_70170_p.field_72995_K);
        }
        return ActionResult.func_226249_b_((Object)stack);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        IFamiliar familiar;
        if (!playerIn.field_70170_p.field_72995_K && target instanceof IFamiliar && ((familiar = (IFamiliar)target).getFamiliarOwner() == playerIn || familiar.getFamiliarOwner() == null) && FamiliarRingItem.getCurio(stack).captureFamiliar(playerIn.field_70170_p, familiar)) {
            OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.CAPTURE);
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74757_a("occupied", true);
            tag.func_74772_a("occupiedTime", playerIn.field_70170_p.func_82737_E());
            ItemNBTUtil.setBoundSpiritName(stack, familiar.getFamiliarEntity().func_145748_c_().getString());
            return ActionResultType.func_233537_a_((boolean)playerIn.field_70170_p.field_72995_K);
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_196082_o().func_74767_n("occupied")) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip", new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new Provider();
    }

    private static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private Curio curio;
        private final LazyOptional<ICurio> instance = LazyOptional.of(this::get);

        private Provider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.instance);
        }

        public CompoundNBT serializeNBT() {
            return this.get().serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.get().deserializeNBT(nbt);
        }

        private Curio get() {
            if (this.curio == null) {
                this.curio = new Curio();
            }
            return this.curio;
        }
    }

    private static class Curio
    implements ICurio,
    INBTSerializable<CompoundNBT> {
        private IFamiliar familiar;
        private CompoundNBT nbt;

        private Curio() {
        }

        private boolean captureFamiliar(World world, IFamiliar familiar) {
            if (this.getFamiliar(world) != null) {
                return false;
            }
            this.setFamiliar(familiar);
            this.getFamiliar(world).getFamiliarEntity().func_184210_p();
            this.getFamiliar(world).getFamiliarEntity().func_184226_ay();
            this.getFamiliar(world).getFamiliarEntity().func_70106_y();
            return true;
        }

        private boolean releaseFamiliar(PlayerEntity player, World world) {
            if (this.getFamiliar(world) != null && !this.getFamiliar(world).getFamiliarEntity().isAddedToWorld()) {
                EntityType.func_220335_a((CompoundNBT)this.getFamiliar(world).getFamiliarEntity().serializeNBT(), (World)world, e -> {
                    e.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                    ((IFamiliar)e).setFamiliarOwner((LivingEntity)player);
                    world.func_217376_c(e);
                    return e;
                });
                this.setFamiliar(null);
                return true;
            }
            return false;
        }

        public void curioTick(String identifier, int index, LivingEntity entity) {
            World world = entity.field_70170_p;
            IFamiliar familiar = this.getFamiliar(world);
            if (familiar != null) {
                if (!familiar.getFamiliarEntity().isAddedToWorld()) {
                    familiar.getFamiliarEntity().field_70170_p = world;
                }
                if (familiar.getFamiliarOwner() != entity) {
                    return;
                }
                if (!world.field_72995_K && entity.field_70173_aa % 20 == 0 && familiar.isEffectEnabled(entity)) {
                    for (EffectInstance effect : familiar.getFamiliarEffects()) {
                        familiar.getFamiliarOwner().func_195064_c(effect);
                    }
                }
                familiar.curioTick(entity);
            }
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74757_a("hasFamiliar", this.familiar != null || this.nbt != null);
            if (this.familiar != null) {
                compound.func_218657_a("familiar", (INBT)this.familiar.getFamiliarEntity().serializeNBT());
            } else if (this.nbt != null) {
                compound.func_218657_a("familiar", (INBT)this.nbt);
            }
            return compound;
        }

        public void deserializeNBT(CompoundNBT compound) {
            if (compound.func_74767_n("hasFamiliar")) {
                this.nbt = compound.func_74775_l("familiar");
            }
        }

        private IFamiliar getFamiliar(World world) {
            if (this.familiar != null) {
                return this.familiar;
            }
            if (this.nbt != null) {
                this.familiar = (IFamiliar)EntityType.func_220335_a((CompoundNBT)this.nbt, (World)world, Function.identity());
                this.nbt = null;
            }
            return this.familiar;
        }

        private void setFamiliar(IFamiliar familiar) {
            this.familiar = familiar;
            this.nbt = null;
        }
    }
}

