/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.util.EntityUtil;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SoulGemItem
extends Item {
    public SoulGemItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_221531_n() != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        World world = context.func_195991_k();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        if (itemStack.func_196082_o().func_74764_b("entityData")) {
            if (!world.field_72995_K) {
                CompoundNBT entityData = itemStack.func_77978_p().func_74775_l("entityData");
                itemStack.func_77978_p().func_82580_o("entityData");
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.func_185334_h();
                if (!world.func_180495_p(spawnPos).func_196951_e((IBlockReader)world, spawnPos).func_197766_b()) {
                    spawnPos = spawnPos.func_177972_a(facing);
                }
                IFormattableTextComponent customName = null;
                if (entityData.func_74764_b("CustomName")) {
                    customName = ITextComponent.Serializer.func_240643_a_((String)entityData.func_74779_i("CustomName"));
                }
                entityData.func_82580_o("Pos");
                CompoundNBT wrapper = new CompoundNBT();
                wrapper.func_218657_a("EntityTag", (INBT)entityData);
                Entity entity = type.func_200721_a(world);
                entity.func_70020_e(entityData);
                entity.func_70080_a((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_217376_c(entity);
                player.func_184609_a(context.func_221531_n());
                player.field_71069_bz.func_75142_b();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        if (!target.func_70089_S()) {
            return ActionResultType.PASS;
        }
        if (target.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (!target.func_184222_aU() || target instanceof PlayerEntity) {
            return ActionResultType.FAIL;
        }
        if (stack.func_196082_o().func_74764_b("entityData")) {
            return ActionResultType.FAIL;
        }
        if (Occultism.SERVER_CONFIG.itemSettings.soulgemEntityTypeDenyList.get().contains(target.func_70022_Q())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".message.entity_type_denied"), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        stack.func_77978_p().func_218657_a("entityData", (INBT)target.serializeNBT());
        player.func_184609_a(hand);
        player.func_184611_a(hand, stack);
        target.remove(true);
        player.field_71069_bz.func_75142_b();
        return ActionResultType.SUCCESS;
    }

    public String func_77667_c(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("entityData") ? this.func_77658_a() : this.func_77658_a() + "_empty";
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_196082_o().func_74764_b("entityData")) {
            EntityType<?> type = EntityUtil.entityTypeFromNbt(stack.func_77978_p().func_74775_l("entityData"));
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip_filled", new Object[]{type.func_212546_e()}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip_empty"));
        }
    }
}

