/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.ai.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventory;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class CrusherJob
extends SpiritJob {
    public static final String DROPPED_BY_CRUSHER = "occultism:dropped_by_crusher";
    protected int crushingTimer;
    protected Supplier<Float> crushingTimeMultiplier;
    protected Supplier<Float> outputMultiplier;
    protected Optional<CrushingRecipe> currentRecipe = Optional.empty();
    protected PickupItemsGoal pickupItemsGoal;
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();

    public CrusherJob(SpiritEntity entity, Supplier<Float> crushingTimeMultiplier, Supplier<Float> outputMultiplier) {
        super(entity);
        this.crushingTimeMultiplier = crushingTimeMultiplier;
        this.outputMultiplier = outputMultiplier;
    }

    @Override
    public void init() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.field_70715_bh.func_75776_a(1, (Goal)this.pickupItemsGoal);
        this.itemsToPickUp = this.entity.field_70170_p.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == OccultismRecipes.CRUSHING_TYPE.get()).flatMap(recipe -> recipe.func_192400_c().stream()).collect(Collectors.toList());
    }

    @Override
    public void cleanup() {
        this.entity.field_70715_bh.func_85156_a((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.func_184586_b(Hand.MAIN_HAND);
        ItemStackFakeInventory fakeInventory = new ItemStackFakeInventory(handHeld);
        if (!this.currentRecipe.isPresent() && !handHeld.func_190926_b()) {
            this.currentRecipe = this.entity.field_70170_p.func_199532_z().func_215371_a((IRecipeType)OccultismRecipes.CRUSHING_TYPE.get(), (IInventory)fakeInventory, this.entity.field_70170_p);
            this.crushingTimer = 0;
            if (this.currentRecipe.isPresent()) {
                this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), (SoundEvent)OccultismSounds.CRUNCHING.get(), SoundCategory.NEUTRAL, 0.5f, 1.0f + 0.5f * this.entity.func_70681_au().nextFloat());
            } else {
                this.entity.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                ItemEntity droppedItem = this.entity.func_199701_a_(handHeld);
                droppedItem.func_184211_a(DROPPED_BY_CRUSHER);
            }
        }
        if (this.currentRecipe.isPresent()) {
            if (handHeld.func_190926_b() || !this.currentRecipe.get().matches(fakeInventory, this.entity.field_70170_p)) {
                this.currentRecipe = Optional.empty();
            } else {
                ++this.crushingTimer;
                if (this.entity.field_70170_p.func_82737_E() % 10L == 0L) {
                    Vector3d pos = this.entity.func_213303_ch();
                    ((ServerWorld)this.entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197599_J, pos.field_72450_a + this.entity.field_70170_p.field_73012_v.nextGaussian() / 3.0, pos.field_72448_b + 0.5, pos.field_72449_c + this.entity.field_70170_p.field_73012_v.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.crushingTimer % 40 == 0) {
                    this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), (SoundEvent)OccultismSounds.CRUNCHING.get(), SoundCategory.NEUTRAL, 0.5f, 1.0f + 0.5f * this.entity.func_70681_au().nextFloat());
                }
                if ((float)this.crushingTimer >= (float)this.currentRecipe.get().getCrushingTime() * this.crushingTimeMultiplier.get().floatValue()) {
                    this.crushingTimer = 0;
                    ItemStack result = this.currentRecipe.get().assemble(fakeInventory);
                    float outputMultiplier = this.outputMultiplier.get().floatValue();
                    if (this.currentRecipe.get().getIgnoreCrushingMultiplier()) {
                        outputMultiplier = 1.0f;
                    }
                    result.func_190920_e((int)((float)result.func_190916_E() * outputMultiplier));
                    ItemStack inputCopy = handHeld.func_77946_l();
                    inputCopy.func_190920_e(1);
                    handHeld.func_190918_g(1);
                    this.onCrush(inputCopy, result);
                    ItemEntity droppedItem = this.entity.func_199701_a_(result);
                    droppedItem.func_184211_a(DROPPED_BY_CRUSHER);
                }
            }
        }
        super.update();
    }

    @Override
    public CompoundNBT writeJobToNBT(CompoundNBT compound) {
        compound.func_74768_a("conversionTimer", this.crushingTimer);
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundNBT compound) {
        super.readJobFromNBT(compound);
        this.crushingTimer = compound.func_74762_e("conversionTimer");
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        if (entity.func_184216_O().contains(DROPPED_BY_CRUSHER) && entity.field_70292_b < Occultism.SERVER_CONFIG.spiritJobs.crusherResultPickupDelay.get()) {
            return false;
        }
        ItemStack stack = entity.func_92059_d();
        return !stack.func_190926_b() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    public void onCrush(ItemStack input, ItemStack output) {
    }
}

