/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.api.common.container.IItemStackComparator;
import com.github.klikli_dev.occultism.common.entity.ai.DepositItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.FellTreesGoal;
import com.github.klikli_dev.occultism.common.entity.ai.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.ReplantSaplingGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.common.misc.ItemTagComparator;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;

public class LumberjackJob
extends SpiritJob {
    protected EntitySize lumberJackDimensions;
    protected ReplantSaplingGoal replantSaplingGoal;
    protected PickupItemsGoal pickupItemsGoal;
    protected FellTreesGoal fellTreesGoal;
    protected DepositItemsGoal depositItemsGoal;
    protected List<IItemStackComparator> itemsToPickUp = new ArrayList<IItemStackComparator>();
    private Set<BlockPos> ignoredTrees = new HashSet<BlockPos>();
    private BlockPos lastFelledTree = null;

    public LumberjackJob(SpiritEntity entity) {
        super(entity);
        this.lumberJackDimensions = EntitySize.func_220314_b((float)0.9f, (float)0.9f);
    }

    @Override
    public void init() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity, 4.0f, 10);
        this.entity.field_70714_bg.func_75776_a(0, (Goal)this.pickupItemsGoal);
        this.fellTreesGoal = new FellTreesGoal(this.entity);
        this.entity.field_70714_bg.func_75776_a(2, (Goal)this.fellTreesGoal);
        this.replantSaplingGoal = new ReplantSaplingGoal(this.entity);
        this.entity.field_70714_bg.func_75776_a(3, (Goal)this.replantSaplingGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.field_70714_bg.func_75776_a(4, (Goal)this.depositItemsGoal);
        this.itemsToPickUp.add(new ItemTagComparator((ITag<Item>)ItemTags.field_200038_h));
        this.itemsToPickUp.add(new ItemTagComparator((ITag<Item>)ItemTags.field_206963_E));
        this.itemsToPickUp.add(new ItemTagComparator((ITag<Item>)ItemTags.field_200037_g));
        this.itemsToPickUp.add(new ItemTagComparator(OccultismTags.FRUITS));
        this.itemsToPickUp.add(new ItemStackComparator(new ItemStack((IItemProvider)Items.field_151055_y), false));
    }

    @Override
    public void cleanup() {
        this.entity.field_70715_bh.func_85156_a((Goal)this.replantSaplingGoal);
        this.entity.field_70715_bh.func_85156_a((Goal)this.pickupItemsGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.fellTreesGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.depositItemsGoal);
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.func_92059_d();
        for (IItemStackComparator comparator : this.itemsToPickUp) {
            if (!comparator.matches(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EntitySize getDimensions(Pose pPose, EntitySize original) {
        return this.fellTreesGoal != null ? (this.fellTreesGoal.shouldUseLumberjackDimensions() ? this.lumberJackDimensions : original) : null;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT list = new ListNBT();
        for (BlockPos ignoredTree : this.ignoredTrees) {
            list.add((Object)LongNBT.func_229698_a_((long)ignoredTree.func_218275_a()));
        }
        compound.func_218657_a("ignoredTrees", (INBT)list);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.ignoredTrees = new HashSet<BlockPos>();
        if (nbt.func_74764_b("ignoredTrees")) {
            ListNBT list = nbt.func_150295_c("ignoredTrees", 9);
            for (int i = 0; i < list.size(); ++i) {
                this.ignoredTrees.add(BlockPos.func_218283_e((long)((LongNBT)list.get(i)).func_150291_c()));
            }
        }
    }

    public Set<BlockPos> getIgnoredTrees() {
        return this.ignoredTrees;
    }

    public void setIgnoredTrees(Set<BlockPos> ignoredTrees) {
        this.ignoredTrees = ignoredTrees;
    }

    public BlockPos getLastFelledTree() {
        return this.lastFelledTree;
    }

    public void setLastFelledTree(BlockPos lastFelledTree) {
        this.lastFelledTree = lastFelledTree;
    }
}

