/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.common.entity.ai.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class TraderJob
extends SpiritJob {
    protected int conversionTimer;
    protected int timeToConvert = 20;
    protected PickupItemsGoal pickupItemsGoal;
    protected SpiritTradeRecipe trade;
    protected int maxTradesPerRound = 4;

    public TraderJob(SpiritEntity entity, ResourceLocation recipeId) {
        super(entity);
        this.setTradeRecipeId(recipeId);
    }

    public int getTimeToConvert() {
        return this.timeToConvert;
    }

    public void setTimeToConvert(int timeToConvert) {
        this.timeToConvert = timeToConvert;
    }

    public void setTradeRecipeId(ResourceLocation recipeId) {
        this.trade = null;
        Optional recipe = this.entity.field_70170_p.func_199532_z().func_215367_a(recipeId);
        recipe.ifPresent(r -> {
            if (r instanceof SpiritTradeRecipe) {
                this.trade = (SpiritTradeRecipe)((Object)r);
            }
        });
    }

    public void setMaxTradesPerRound(int trades) {
        this.maxTradesPerRound = trades;
    }

    @Override
    public void init() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.field_70715_bh.func_75776_a(1, (Goal)this.pickupItemsGoal);
    }

    @Override
    public void cleanup() {
        this.entity.field_70715_bh.func_85156_a((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.func_184586_b(Hand.MAIN_HAND);
        if (this.trade != null && this.trade.isValid(handHeld)) {
            if (this.entity.field_70170_p.func_82737_E() % 10L == 0L) {
                Vector3d pos = this.entity.func_213303_ch();
                ((ServerWorld)this.entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197599_J, pos.field_72450_a + this.entity.field_70170_p.field_73012_v.nextGaussian() / 3.0, pos.field_72448_b + 0.5, pos.field_72449_c + this.entity.field_70170_p.field_73012_v.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.entity.field_70170_p.func_82737_E() % 20L == 0L) {
                ++this.conversionTimer;
            }
            if (this.conversionTimer >= this.getTimeToConvert()) {
                int resultCount;
                this.conversionTimer = 0;
                List<ItemStack> input = Collections.singletonList(handHeld);
                for (resultCount = 0; this.trade.isValid(input) && resultCount < this.maxTradesPerRound; ++resultCount) {
                    input = this.trade.consume(input);
                }
                if (input.isEmpty()) {
                    this.entity.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                } else {
                    this.entity.func_184611_a(Hand.MAIN_HAND, input.get(0));
                }
                ItemStack converted = this.trade.func_77571_b().func_77946_l();
                converted.func_190920_e(converted.func_190916_E() * resultCount);
                if (resultCount > 0) {
                    this.entity.func_70099_a(converted, 0.0f);
                    this.onConvert(resultCount);
                }
            }
        } else {
            this.conversionTimer = 0;
        }
        super.update();
    }

    @Override
    public CompoundNBT writeJobToNBT(CompoundNBT compound) {
        compound.func_74768_a("timeToConvert", this.timeToConvert);
        compound.func_74768_a("conversionTimer", this.conversionTimer);
        compound.func_74768_a("maxTradesPerRound", this.maxTradesPerRound);
        if (this.trade != null) {
            compound.func_74778_a("spiritTradeId", this.trade.func_199560_c().toString());
        }
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundNBT compound) {
        super.readJobFromNBT(compound);
        this.timeToConvert = compound.func_74762_e("timeToConvert");
        this.conversionTimer = compound.func_74762_e("conversionTimer");
        this.maxTradesPerRound = compound.func_74762_e("maxTradesPerRound");
        if (compound.func_74764_b("spiritTradeId")) {
            this.setTradeRecipeId(new ResourceLocation(compound.func_74779_i("spiritTradeId")));
        }
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.func_92059_d();
        return !stack.func_190926_b() && this.trade.isValid(stack);
    }

    public void onConvert(int count) {
    }
}

