/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.tile.GoldenSacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.common.tile.SacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public abstract class Ritual {
    public static final int SACRIFICIAL_BOWL_RANGE = 8;
    public static final int SACRIFICE_DETECTION_RANGE = 8;
    public static final int SACRIFICE_DETECTION_RANGE_SQUARE = 64;
    public static final int ITEM_USE_DETECTION_RANGE = 16;
    public static final int ITEM_USE_DETECTION_RANGE_SQUARE = 256;
    public RitualRecipe recipe;
    public ResourceLocation factoryId;

    public Ritual(RitualRecipe recipe) {
        this.recipe = recipe;
    }

    public static List<Ingredient> getRemainingAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> consumedIngredients) {
        ArrayList<ItemStack> consumedIngredientsCopy = new ArrayList<ItemStack>(consumedIngredients);
        ArrayList<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
        for (Ingredient ingredient : additionalIngredients) {
            Optional<ItemStack> matchedStack = consumedIngredientsCopy.stream().filter(arg_0 -> ((Ingredient)ingredient).test(arg_0)).findFirst();
            if (matchedStack.isPresent()) {
                consumedIngredientsCopy.remove(matchedStack.get());
                continue;
            }
            remainingAdditionalIngredients.add(ingredient);
        }
        return remainingAdditionalIngredients;
    }

    public ResourceLocation getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryId(ResourceLocation factoryId) {
        this.factoryId = factoryId;
    }

    public RitualRecipe getRecipe() {
        return this.recipe;
    }

    public String getRitualID() {
        ResourceLocation recipeId = this.getRecipe().func_199560_c();
        String path = recipeId.func_110623_a();
        if (path.contains("/")) {
            path = path.substring(path.indexOf("/") + 1);
        }
        return recipeId.func_110624_b() + "." + path;
    }

    public String getConditionsMessage() {
        return String.format("ritual.%s.conditions", this.getRitualID());
    }

    public String getStartedMessage() {
        return String.format("ritual.%s.started", this.getRitualID());
    }

    public String getInterruptedMessage() {
        return String.format("ritual.%s.interrupted", this.getRitualID());
    }

    public String getFinishedMessage() {
        return String.format("ritual.%s.finished", this.getRitualID());
    }

    public boolean isValid(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return this.recipe.getPentacle() != null && this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(world, goldenBowlPosition, remainingAdditionalIngredients) && this.recipe.getPentacle().validate(world, goldenBowlPosition);
    }

    public void start(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        world.func_184133_a(null, goldenBowlPosition, (SoundEvent)OccultismSounds.START_RITUAL.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        castingPlayer.func_146105_b((ITextComponent)new TranslationTextComponent(this.getStartedMessage()), true);
    }

    public void finish(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        world.func_184133_a(null, goldenBowlPosition, (SoundEvent)OccultismSounds.POOF.get(), SoundCategory.BLOCKS, 0.7f, 0.7f);
        castingPlayer.func_146105_b((ITextComponent)new TranslationTextComponent(this.getFinishedMessage()), true);
        OccultismAdvancements.RITUAL.trigger((ServerPlayerEntity)castingPlayer, this);
    }

    public void interrupt(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        world.func_184133_a(null, goldenBowlPosition, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.7f, 0.7f);
        castingPlayer.func_146105_b((ITextComponent)new TranslationTextComponent(this.getInterruptedMessage()), true);
    }

    public void update(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients, int time) {
    }

    public void update(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem, int time) {
        this.update(world, goldenBowlPosition, tileEntity, castingPlayer, activationItem, new ArrayList<Ingredient>(), time);
    }

    public boolean identify(World world, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return this.recipe.getPentacle() != null && this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(world, goldenBowlPosition, (List<Ingredient>)this.recipe.func_192400_c()) && this.recipe.getPentacle().validate(world, goldenBowlPosition);
    }

    public boolean consumeAdditionalIngredients(World world, BlockPos goldenBowlPosition, List<Ingredient> remainingAdditionalIngredients, int time, List<ItemStack> consumedIngredients) {
        int ingredientsConsumed;
        if (remainingAdditionalIngredients.isEmpty()) {
            return true;
        }
        int totalIngredientsToConsume = (int)Math.floor((float)time / this.recipe.getDurationPerIngredient());
        int ingredientsToConsume = totalIngredientsToConsume - (ingredientsConsumed = consumedIngredients.size());
        if (ingredientsToConsume == 0) {
            return true;
        }
        List<SacrificialBowlTileEntity> sacrificialBowls = this.getSacrificialBowls(world, goldenBowlPosition);
        Iterator<Ingredient> it = remainingAdditionalIngredients.iterator();
        for (int consumed = 0; it.hasNext() && consumed < ingredientsToConsume; ++consumed) {
            Ingredient ingredient = it.next();
            if (!this.consumeAdditionalIngredient(world, goldenBowlPosition, sacrificialBowls, ingredient, consumedIngredients)) {
                return false;
            }
            it.remove();
        }
        return true;
    }

    public boolean consumeAdditionalIngredient(World world, BlockPos goldenBowlPosition, List<SacrificialBowlTileEntity> sacrificialBowls, Ingredient ingredient, List<ItemStack> consumedIngredients) {
        for (SacrificialBowlTileEntity sacrificialBowl : sacrificialBowls) {
            if (!sacrificialBowl.itemStackHandler.map(handler -> {
                ItemStack stack = handler.extractItem(0, 1, true);
                if (ingredient.test(stack)) {
                    ItemStack extracted = handler.extractItem(0, 1, false);
                    consumedIngredients.add(extracted);
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)sacrificialBowl.func_174877_v().func_177958_n() + 0.5, (double)sacrificialBowl.func_174877_v().func_177956_o() + 1.5, (double)sacrificialBowl.func_174877_v().func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    world.func_184133_a(null, sacrificialBowl.func_174877_v(), (SoundEvent)OccultismSounds.POOF.get(), SoundCategory.BLOCKS, 0.7f, 0.7f);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean areAdditionalIngredientsFulfilled(World world, BlockPos goldenBowlPosition, List<Ingredient> additionalIngredients) {
        return this.matchesAdditionalIngredients(additionalIngredients, this.getItemsOnSacrificialBowls(world, goldenBowlPosition));
    }

    public boolean matchesAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> items) {
        if (Occultism.SERVER_CONFIG.rituals.enableRemainingIngredientCountMatching.get() && additionalIngredients.size() != items.size()) {
            return false;
        }
        if (additionalIngredients.isEmpty()) {
            return true;
        }
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>(items);
        for (Ingredient ingredient : additionalIngredients) {
            boolean isMatched = false;
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack stack = (ItemStack)remainingItems.get(i);
                if (!ingredient.test(stack)) continue;
                isMatched = true;
                remainingItems.remove(i);
                break;
            }
            if (isMatched) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getItemsOnSacrificialBowls(World world, BlockPos goldenBowlPosition) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<SacrificialBowlTileEntity> sacrificialBowls = this.getSacrificialBowls(world, goldenBowlPosition);
        for (SacrificialBowlTileEntity sacrificialBowl : sacrificialBowls) {
            sacrificialBowl.itemStackHandler.ifPresent(handler -> {
                ItemStack stack = handler.getStackInSlot(0);
                if (!stack.func_190926_b()) {
                    result.add(stack);
                }
            });
        }
        return result;
    }

    public List<SacrificialBowlTileEntity> getSacrificialBowls(World world, BlockPos goldenBowlPosition) {
        ArrayList<SacrificialBowlTileEntity> result = new ArrayList<SacrificialBowlTileEntity>();
        Iterable blocksToCheck = BlockPos.func_218278_a((BlockPos)goldenBowlPosition.func_177982_a(-8, 0, -8), (BlockPos)goldenBowlPosition.func_177982_a(8, 0, 8));
        for (BlockPos blockToCheck : blocksToCheck) {
            TileEntity tileEntity = world.func_175625_s(blockToCheck);
            if (!(tileEntity instanceof SacrificialBowlTileEntity) || tileEntity instanceof GoldenSacrificialBowlTileEntity) continue;
            result.add((SacrificialBowlTileEntity)tileEntity);
        }
        return result;
    }

    public void prepareLivingEntityForSpawn(LivingEntity livingEntity, World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, String spiritName) {
        this.prepareLivingEntityForSpawn(livingEntity, world, goldenBowlPosition, tileEntity, castingPlayer, spiritName, true);
    }

    public void prepareLivingEntityForSpawn(LivingEntity livingEntity, World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, String spiritName, boolean setTamed) {
        if (setTamed && livingEntity instanceof TameableEntity) {
            ((TameableEntity)livingEntity).func_193101_c(castingPlayer);
        }
        livingEntity.func_70080_a((double)goldenBowlPosition.func_177958_n(), (double)goldenBowlPosition.func_177956_o(), (double)goldenBowlPosition.func_177952_p(), (float)world.field_73012_v.nextInt(360), 0.0f);
        if (spiritName.length() > 0) {
            livingEntity.func_200203_b((ITextComponent)new StringTextComponent(spiritName));
        }
        if (livingEntity instanceof MobEntity) {
            ((MobEntity)livingEntity).func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(goldenBowlPosition), SpawnReason.MOB_SUMMONED, null, null);
        }
    }

    public boolean isValidSacrifice(LivingEntity entity) {
        return entity != null && this.recipe.requiresSacrifice() && this.recipe.getEntityToSacrifice().func_230235_a_((Object)entity.func_200600_R());
    }

    public boolean isValidItemUse(PlayerInteractEvent.RightClickItem event) {
        return this.recipe.requiresItemUse() && this.recipe.getItemToUse().test(event.getItemStack());
    }

    public boolean requiresSacrifice() {
        return this.recipe.requiresSacrifice();
    }

    public boolean require() {
        return this.recipe.requiresItemUse();
    }

    public void dropResult(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack stack) {
        double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
        ItemEntity entity = new ItemEntity(world, (double)goldenBowlPosition.func_177958_n() + 0.5, (double)goldenBowlPosition.func_177956_o() + 0.75, (double)goldenBowlPosition.func_177952_p() + 0.5, stack);
        entity.func_213293_j(Math.sin(angle) * 0.125, 0.25, Math.cos(angle) * 0.125);
        entity.func_174867_a(10);
        world.func_217376_c((Entity)entity);
    }
}

