/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual.pentacle;

import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.network.MessageUpdatePentacles;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PentacleManager
extends JsonReloadListener {
    public static final String FOLDER_NAME = "occultism_pentacles";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static PentacleManager instance;
    private final Map<ResourceLocation, Pentacle> pentacles = new HashMap<ResourceLocation, Pentacle>();

    public PentacleManager() {
        super(GSON, FOLDER_NAME);
    }

    public static PentacleManager getInstance() {
        if (instance == null) {
            instance = new PentacleManager();
        }
        return instance;
    }

    public static Pentacle get(ResourceLocation id) {
        return PentacleManager.getInstance().pentacles.get(id);
    }

    public static Pentacle get(String modid, String path) {
        return PentacleManager.getInstance().pentacles.get(new ResourceLocation(modid, path));
    }

    public static Map<ResourceLocation, Pentacle> getAllPentacles() {
        return PentacleManager.getInstance().pentacles;
    }

    @SubscribeEvent
    public static void addPentacleReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)PentacleManager.getInstance());
    }

    @SubscribeEvent
    public static void syncPentacles(PlayerEvent.PlayerLoggedInEvent event) {
        PentacleManager.getInstance().sendPentacleMessage((ServerPlayerEntity)event.getPlayer());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation key = entry.getKey();
            Pentacle pentacle = Pentacle.fromJson(key, JSONUtils.func_151210_l((JsonElement)entry.getValue(), (String)"top element"));
            this.pentacles.put(key, pentacle);
        }
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.sendPentacleMessage();
        }
    }

    private void sendPentacleMessage() {
        OccultismPackets.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdatePentacles(this.pentacles));
    }

    private void sendPentacleMessage(ServerPlayerEntity player) {
        OccultismPackets.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageUpdatePentacles(this.pentacles));
    }

    public void setPentacles(Map<ResourceLocation, Pentacle> pentacles) {
        this.pentacles.putAll(pentacles);
    }
}

