/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.tile;

import com.github.klikli_dev.occultism.common.container.DimensionalMineshaftContainer;
import com.github.klikli_dev.occultism.common.misc.WeightedIngredient;
import com.github.klikli_dev.occultism.common.tile.NetworkedTileEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DimensionalMineshaftTileEntity
extends NetworkedTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final String MAX_MINING_TIME_TAG = "maxMiningTime";
    public static final int DEFAULT_MAX_MINING_TIME = 400;
    public static int DEFAULT_ROLLS_PER_OPERATION = 1;
    public static String ROLLS_PER_OPERATION_TAG = "rollsPerOperation";
    public LazyOptional<ItemStackHandler> inputHandler = LazyOptional.of(() -> new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DimensionalMineshaftTileEntity.this.func_70296_d();
        }
    });
    public LazyOptional<ItemStackHandler> outputHandler = LazyOptional.of(() -> new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            DimensionalMineshaftTileEntity.this.func_70296_d();
        }
    });
    public LazyOptional<CombinedInvWrapper> combinedHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.inputHandler.orElseThrow(ItemHandlerMissingException::new), (IItemHandlerModifiable)this.outputHandler.orElseThrow(ItemHandlerMissingException::new)}));
    public int miningTime;
    public int maxMiningTime = 0;
    public int rollsPerOperation = 0;
    protected Item currentInputType;
    protected List<WeightedIngredient> possibleResults;

    public DimensionalMineshaftTileEntity() {
        super((TileEntityType)OccultismTiles.DIMENSIONAL_MINESHAFT.get());
    }

    public static void forceInitStackNBT(ItemStack stack, ServerWorld world) {
        stack.func_77973_b().func_77622_d(stack, (World)world, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)world));
    }

    public static int getMaxMiningTime(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return 0;
        }
        int time = tag.func_74762_e(MAX_MINING_TIME_TAG);
        return time <= 0 ? 400 : time;
    }

    public static int getRollsPerOperation(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return 0;
        }
        int rolls = tag.func_74762_e(ROLLS_PER_OPERATION_TAG);
        return rolls <= 0 ? DEFAULT_ROLLS_PER_OPERATION : rolls;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (direction == null) {
                return this.combinedHandler.cast();
            }
            if (direction == Direction.UP) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inputHandler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l("inputHandler")));
        this.outputHandler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l("outputHandler")));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.inputHandler.ifPresent(handler -> compound.func_218657_a("inputHandler", (INBT)handler.serializeNBT()));
        this.outputHandler.ifPresent(handler -> compound.func_218657_a("outputHandler", (INBT)handler.serializeNBT()));
        return super.func_189515_b(compound);
    }

    @Override
    public void readNetwork(CompoundNBT compound) {
        super.readNetwork(compound);
        this.miningTime = compound.func_74762_e("miningTime");
        this.maxMiningTime = compound.func_74762_e(MAX_MINING_TIME_TAG);
    }

    @Override
    public CompoundNBT writeNetwork(CompoundNBT compound) {
        compound.func_74768_a("miningTime", this.miningTime);
        compound.func_74768_a(MAX_MINING_TIME_TAG, this.maxMiningTime);
        return super.writeNetwork(compound);
    }

    public void func_145843_s() {
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IItemHandler inputHandler = (IItemHandler)this.inputHandler.orElseThrow(ItemHandlerMissingException::new);
            ItemStack input = inputHandler.getStackInSlot(0);
            boolean dirty = false;
            if (this.miningTime > 0) {
                --this.miningTime;
                if (this.miningTime == 0 && !this.field_145850_b.field_72995_K) {
                    this.mine();
                }
                if (input.func_77973_b() != this.currentInputType) {
                    this.miningTime = 0;
                    this.possibleResults = null;
                }
                if (this.miningTime % 10 == 0) {
                    dirty = true;
                }
            } else if (!input.func_190926_b()) {
                this.currentInputType = input.func_77973_b();
                DimensionalMineshaftTileEntity.forceInitStackNBT(input, (ServerWorld)this.field_145850_b);
                this.maxMiningTime = DimensionalMineshaftTileEntity.getMaxMiningTime(input);
                this.rollsPerOperation = DimensionalMineshaftTileEntity.getRollsPerOperation(input);
                this.miningTime = this.maxMiningTime;
                dirty = true;
            }
            if (dirty) {
                this.markNetworkDirty();
            }
        } else if (this.miningTime > 0 && this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)this.field_174879_c.func_177956_o() + 0.5, (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new DimensionalMineshaftContainer(id, playerInventory, this);
    }

    public void mine() {
        ItemStackHandler inputHandler = (ItemStackHandler)this.inputHandler.orElseThrow(ItemHandlerMissingException::new);
        ItemStackHandler outputHandler = (ItemStackHandler)this.outputHandler.orElseThrow(ItemHandlerMissingException::new);
        if (this.possibleResults == null) {
            List recipes = this.field_145850_b.func_199532_z().func_215370_b((IRecipeType)OccultismRecipes.MINER_TYPE.get(), (IInventory)new RecipeWrapper((IItemHandlerModifiable)inputHandler), this.field_145850_b);
            this.possibleResults = recipes == null || recipes.size() == 0 ? new ArrayList<WeightedIngredient>() : recipes.stream().map(r -> r.getWeightedOutput()).collect(Collectors.toList());
        }
        if (this.possibleResults.size() == 0) {
            return;
        }
        for (int i = 0; i < this.rollsPerOperation; ++i) {
            WeightedIngredient result = (WeightedIngredient)WeightedRandom.func_76271_a((Random)this.field_145850_b.field_73012_v, this.possibleResults);
            ItemHandlerHelper.insertItemStacked((IItemHandler)outputHandler, (ItemStack)result.getStack().func_77946_l(), (boolean)false);
        }
        ItemStack input = inputHandler.getStackInSlot(0);
        if (input.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
            input.func_190918_g(1);
            input.func_196085_b(0);
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
        this.combinedHandler.invalidate();
    }
}

