/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.tile;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.item.DummyTooltipItem;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfBindingItem;
import com.github.klikli_dev.occultism.common.ritual.Ritual;
import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.common.ritual.pentacle.PentacleManager;
import com.github.klikli_dev.occultism.common.tile.SacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismParticles;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.EntityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.items.IItemHandler;

public class GoldenSacrificialBowlTileEntity
extends SacrificialBowlTileEntity
implements ITickableTileEntity {
    public RitualRecipe currentRitualRecipe;
    public ResourceLocation currentRitualRecipeId;
    public UUID castingPlayerId;
    public PlayerEntity castingPlayer;
    public List<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
    public List<ItemStack> consumedIngredients = new ArrayList<ItemStack>();
    public boolean sacrificeProvided;
    public boolean itemUseProvided;
    public int currentTime;
    public Consumer<PlayerInteractEvent.RightClickItem> rightClickItemListener = this::onPlayerRightClickItem;
    public Consumer<LivingDeathEvent> livingDeathEventListener = this::onLivingDeath;

    public GoldenSacrificialBowlTileEntity() {
        super((TileEntityType)OccultismTiles.GOLDEN_SACRIFICIAL_BOWL.get());
    }

    public RitualRecipe getCurrentRitualRecipe() {
        if (this.currentRitualRecipeId != null && this.field_145850_b != null) {
            Optional recipe = this.field_145850_b.func_199532_z().func_215367_a(this.currentRitualRecipeId);
            recipe.map(r -> (RitualRecipe)((Object)r)).ifPresent(r -> {
                this.currentRitualRecipe = r;
            });
            MinecraftForge.EVENT_BUS.addListener(this.rightClickItemListener);
            MinecraftForge.EVENT_BUS.addListener(this.livingDeathEventListener);
            this.currentRitualRecipeId = null;
        }
        return this.currentRitualRecipe;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.consumedIngredients.clear();
        if (this.currentRitualRecipeId != null || this.getCurrentRitualRecipe() != null) {
            if (compound.func_74764_b("consumedIngredients")) {
                ListNBT list = compound.func_150295_c("consumedIngredients", 10);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
                    this.consumedIngredients.add(stack);
                }
            }
            this.restoreRemainingAdditionalIngredients();
        }
        if (compound.func_74764_b("sacrificeProvided")) {
            this.sacrificeProvided = compound.func_74767_n("sacrificeProvided");
        }
        if (compound.func_74764_b("requiredItemUsed")) {
            this.itemUseProvided = compound.func_74767_n("requiredItemUsed");
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.getCurrentRitualRecipe() != null) {
            if (this.consumedIngredients.size() > 0) {
                ListNBT list = new ListNBT();
                for (ItemStack stack : this.consumedIngredients) {
                    list.add((Object)stack.serializeNBT());
                }
                compound.func_218657_a("consumedIngredients", (INBT)list);
            }
            compound.func_74757_a("sacrificeProvided", this.sacrificeProvided);
            compound.func_74757_a("requiredItemUsed", this.itemUseProvided);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void readNetwork(CompoundNBT compound) {
        super.readNetwork(compound);
        if (compound.func_74764_b("currentRitual")) {
            this.currentRitualRecipeId = new ResourceLocation(compound.func_74779_i("currentRitual"));
        }
        if (compound.func_74764_b("castingPlayerId")) {
            this.castingPlayerId = compound.func_186857_a("castingPlayerId");
        }
        this.currentTime = compound.func_74762_e("currentTime");
    }

    @Override
    public CompoundNBT writeNetwork(CompoundNBT compound) {
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (recipe != null) {
            compound.func_74778_a("currentRitual", recipe.func_199560_c().toString());
        }
        if (this.castingPlayerId != null) {
            compound.func_186854_a("castingPlayerId", this.castingPlayerId);
        }
        compound.func_74768_a("currentTime", this.currentTime);
        return super.writeNetwork(compound);
    }

    public void func_73660_a() {
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (!this.field_145850_b.field_72995_K && recipe != null) {
            this.restoreCastingPlayer();
            if (this.remainingAdditionalIngredients == null) {
                this.restoreRemainingAdditionalIngredients();
                if (this.remainingAdditionalIngredients == null) {
                    Occultism.LOGGER.warn("Could not restore remainingAdditionalIngredients during tick - world seems to be null. Will attempt again next tick.");
                    return;
                }
            }
            IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            if (!recipe.getRitual().isValid(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, handler.getStackInSlot(0), this.remainingAdditionalIngredients)) {
                this.stopRitual(false);
                return;
            }
            if (this.castingPlayer == null || !this.sacrificeFulfilled() || !this.itemUseFulfilled()) {
                if (this.field_145850_b.field_73012_v.nextInt(16) == 0) {
                    ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)OccultismParticles.RITUAL_WAITING.get(), (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), 3, 0.0, 0.0, 0.0, 0.0);
                    ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)OccultismParticles.RITUAL_WAITING.get(), (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), 3, 0.0, 0.0, 0.0, 0.0);
                }
                return;
            }
            if (this.field_145850_b.field_73012_v.nextInt(16) == 0) {
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)this.field_174879_c.func_177958_n() + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() / 3.0, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() / 3.0, 5, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.field_145850_b.func_82737_E() % (long)((int)(20.0f * Occultism.SERVER_CONFIG.rituals.ritualDurationMultiplier.get())) == 0L) {
                ++this.currentTime;
            }
            recipe.getRitual().update(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, handler.getStackInSlot(0), this.currentTime);
            if (!recipe.getRitual().consumeAdditionalIngredients(this.field_145850_b, this.field_174879_c, this.remainingAdditionalIngredients, this.currentTime, this.consumedIngredients)) {
                this.stopRitual(false);
                return;
            }
            if (recipe.getDuration() >= 0 && this.currentTime >= recipe.getDuration()) {
                this.stopRitual(true);
            }
        }
    }

    public void restoreCastingPlayer() {
        if (this.castingPlayer == null && this.castingPlayerId != null && this.field_145850_b.func_82737_E() % 600L == 0L) {
            this.castingPlayer = EntityUtil.getPlayerByUuiDGlobal(this.castingPlayerId).orElse(null);
            this.func_70296_d();
            this.markNetworkDirty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean activate(World world, BlockPos pos, PlayerEntity player, Hand hand, Direction face) {
        if (world.field_72995_K) return true;
        ItemStack activationItem = player.func_184586_b(hand);
        if (activationItem == ItemStack.field_190927_a) {
            return false;
        }
        if (activationItem.func_77973_b() instanceof DummyTooltipItem) {
            ((DummyTooltipItem)activationItem.func_77973_b()).performRitual(world, pos, this, player, activationItem);
            return true;
        }
        if (this.getCurrentRitualRecipe() != null) {
            this.stopRitual(false);
            return true;
        }
        RitualRecipe ritualRecipe = this.field_145850_b.func_199532_z().func_241447_a_((IRecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> r.matches(world, pos, activationItem)).findFirst().orElse(null);
        if (ritualRecipe != null) {
            if (ritualRecipe.getRitual().isValid(world, pos, this, player, activationItem, (List<Ingredient>)ritualRecipe.func_192400_c())) {
                this.startRitual(player, activationItem, ritualRecipe);
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent(ritualRecipe.getRitual().getConditionsMessage()), true);
            return false;
        }
        if (activationItem.func_77973_b() instanceof BookOfBindingItem) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(String.format("ritual.%s.book_not_bound", "occultism")), false);
            return false;
        }
        if (GoldenSacrificialBowlTileEntity.helpWithPentacle(world, pos, player)) return false;
        if (GoldenSacrificialBowlTileEntity.helpWithRitual(world, pos, player, activationItem)) return false;
        player.func_146105_b((ITextComponent)new TranslationTextComponent(String.format("ritual.%s.does_not_exist", "occultism")), false);
        return false;
    }

    private static boolean helpWithPentacle(World world, BlockPos pos, PlayerEntity player) {
        Map<BlockPos, Block> pentacleDiff = null;
        Map<BlockPos, Block> bestPentacleDiff = null;
        Pentacle bestMatch = null;
        for (Pentacle pentacle : PentacleManager.getAllPentacles().values()) {
            pentacleDiff = pentacle.getDifference(world, pos);
            if (bestPentacleDiff != null && bestPentacleDiff.size() <= pentacleDiff.size()) continue;
            bestPentacleDiff = pentacleDiff;
            bestMatch = pentacle;
        }
        if (bestPentacleDiff != null && !bestPentacleDiff.isEmpty() && bestPentacleDiff.size() < 4) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("ritual.occultism.pentacle_help", new Object[]{new TranslationTextComponent(bestMatch.getTranslationKey()), GoldenSacrificialBowlTileEntity.pentacleDiffToComponent(bestPentacleDiff)}), false);
            return true;
        }
        return false;
    }

    private static StringTextComponent pentacleDiffToComponent(Map<BlockPos, Block> bestPentacleDiff) {
        StringTextComponent text = new StringTextComponent("");
        for (Map.Entry<BlockPos, Block> entry : bestPentacleDiff.entrySet()) {
            text.func_230529_a_((ITextComponent)new TranslationTextComponent(entry.getValue().func_149739_a()));
            text.func_230529_a_((ITextComponent)new TranslationTextComponent("ritual.occultism.pentacle_help_at_glue"));
            BlockPos pos = entry.getKey();
            text.func_230529_a_((ITextComponent)new StringTextComponent("x: " + pos.func_177958_n() + ", y: " + pos.func_177956_o() + ", z: " + pos.func_177952_p() + "\n"));
        }
        return text;
    }

    private static boolean helpWithRitual(World world, BlockPos pos, PlayerEntity player, ItemStack activationItem) {
        ArrayList ritualDiff = null;
        ArrayList bestRitualDiff = null;
        RitualRecipe bestRitual = null;
        Pentacle pentacle = null;
        for (Pentacle p : PentacleManager.getAllPentacles().values()) {
            if (!p.validate(world, pos)) continue;
            pentacle = p;
            break;
        }
        if (pentacle == null) {
            return false;
        }
        for (RitualRecipe recipe : world.func_199532_z().func_241447_a_((IRecipeType)OccultismRecipes.RITUAL_TYPE.get())) {
            if (recipe.getPentacle() != pentacle) continue;
            ritualDiff = new ArrayList(recipe.func_192400_c());
            List<ItemStack> items = recipe.getRitual().getItemsOnSacrificialBowls(world, pos);
            boolean found = false;
            for (int i = ritualDiff.size() - 1; i >= 0; --i) {
                found = false;
                for (int j = 0; j < items.size(); ++j) {
                    if (!((Ingredient)ritualDiff.get(i)).test(items.get(j))) continue;
                    items.remove(j);
                    found = true;
                    break;
                }
                if (!found) continue;
                ritualDiff.remove(i);
            }
            if (bestRitualDiff != null && bestRitualDiff.size() <= ritualDiff.size()) continue;
            bestRitualDiff = ritualDiff;
            bestRitual = recipe;
        }
        if (bestRitualDiff != null && !bestRitualDiff.isEmpty() && bestRitualDiff.size() < 4) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("ritual.occultism.ritual_help", new Object[]{new TranslationTextComponent(bestRitual.getRitual().getStartedMessage()), GoldenSacrificialBowlTileEntity.ritualDiffToComponent(bestRitualDiff)}), false);
            return true;
        }
        return false;
    }

    private static Object ritualDiffToComponent(List<Ingredient> ritualDiff) {
        Random rand = new Random();
        StringTextComponent text = new StringTextComponent("");
        for (Ingredient ingredient : ritualDiff) {
            if (ingredient.func_193365_a().length == 0) continue;
            text.func_230529_a_(ingredient.func_193365_a()[rand.nextInt(ingredient.func_193365_a().length)].func_151000_E());
            text.func_240702_b_("\n");
        }
        return text;
    }

    public void startRitual(PlayerEntity player, ItemStack activationItem, RitualRecipe ritualRecipe) {
        if (!this.field_145850_b.field_72995_K) {
            this.currentRitualRecipe = ritualRecipe;
            this.castingPlayerId = player.func_110124_au();
            this.castingPlayer = player;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            this.consumedIngredients.clear();
            this.remainingAdditionalIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)this.currentRitualRecipe.func_192400_c());
            IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            handler.insertItem(0, activationItem.func_77979_a(1), false);
            this.currentRitualRecipe.getRitual().start(this.field_145850_b, this.field_174879_c, this, player, handler.getStackInSlot(0));
            MinecraftForge.EVENT_BUS.addListener(this.rightClickItemListener);
            MinecraftForge.EVENT_BUS.addListener(this.livingDeathEventListener);
            this.func_70296_d();
            this.markNetworkDirty();
        }
    }

    public void stopRitual(boolean finished) {
        if (!this.field_145850_b.field_72995_K) {
            RitualRecipe recipe = this.getCurrentRitualRecipe();
            if (recipe != null && this.castingPlayer != null) {
                IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
                if (finished) {
                    ItemStack activationItem = handler.getStackInSlot(0);
                    recipe.getRitual().finish(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, activationItem);
                } else {
                    recipe.getRitual().interrupt(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, handler.getStackInSlot(0));
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)handler.extractItem(0, 1, false));
                }
            }
            this.currentRitualRecipe = null;
            this.castingPlayerId = null;
            this.castingPlayer = null;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            if (this.remainingAdditionalIngredients != null) {
                this.remainingAdditionalIngredients.clear();
            }
            this.consumedIngredients.clear();
            MinecraftForge.EVENT_BUS.unregister(this.rightClickItemListener);
            MinecraftForge.EVENT_BUS.unregister(this.livingDeathEventListener);
            this.func_70296_d();
            this.markNetworkDirty();
        }
    }

    public boolean sacrificeFulfilled() {
        return !this.getCurrentRitualRecipe().requiresSacrifice() || this.sacrificeProvided;
    }

    public boolean itemUseFulfilled() {
        return !this.getCurrentRitualRecipe().requiresItemUse() || this.itemUseProvided;
    }

    public void notifySacrifice(LivingEntity entityLivingBase) {
        this.sacrificeProvided = true;
    }

    public void notifyItemUse(PlayerInteractEvent.RightClickItem event) {
        this.itemUseProvided = true;
    }

    protected void restoreRemainingAdditionalIngredients() {
        this.remainingAdditionalIngredients = this.field_145850_b == null ? null : (this.consumedIngredients.size() > 0 ? Ritual.getRemainingAdditionalIngredients((List<Ingredient>)this.getCurrentRitualRecipe().func_192400_c(), this.consumedIngredients) : new ArrayList<Ingredient>((Collection<Ingredient>)this.getCurrentRitualRecipe().func_192400_c()));
    }

    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && this.getCurrentRitualRecipe() != null && this.func_174877_v().func_177951_i((Vector3i)event.getPos()) <= 256.0 && this.getCurrentRitualRecipe().getRitual().isValidItemUse(event)) {
            this.notifyItemUse(event);
        }
    }

    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entityLivingBase = event.getEntityLiving();
        if (!entityLivingBase.field_70170_p.field_72995_K && this.getCurrentRitualRecipe() != null && event.getSource().func_76346_g() instanceof PlayerEntity && this.func_174877_v().func_177951_i((Vector3i)entityLivingBase.func_233580_cy_()) <= 64.0 && this.getCurrentRitualRecipe().getRitual().isValidSacrifice(entityLivingBase)) {
            this.notifySacrifice(entityLivingBase);
        }
    }
}

