/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.tile;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.api.common.tile.IStorageAccessor;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.api.common.tile.IStorageControllerProxy;
import com.github.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.github.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.github.klikli_dev.occultism.common.tile.NetworkedTileEntity;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.TileEntityUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class StableWormholeTileEntity
extends NetworkedTileEntity
implements IStorageControllerProxy,
INamedContainerProvider,
IStorageAccessor {
    protected GlobalBlockPos linkedStorageControllerPosition;
    protected Map<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
    protected ItemStack orderStack = ItemStack.field_190927_a;
    protected SortDirection sortDirection = SortDirection.DOWN;
    protected SortType sortType = SortType.AMOUNT;

    public StableWormholeTileEntity() {
        super((TileEntityType)OccultismTiles.STABLE_WORMHOLE.get());
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Override
    public SortType getSortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public Map<Integer, ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public ItemStack getOrderStack() {
        return this.orderStack;
    }

    @Override
    public void setOrderStack(@Nonnull ItemStack orderStack) {
        this.orderStack = orderStack;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Override
    public IStorageController getLinkedStorageController() {
        if (this.linkedStorageControllerPosition != null) {
            TileEntity tileEntity = TileEntityUtil.get(this.field_145850_b, this.linkedStorageControllerPosition);
            if (tileEntity instanceof IStorageController) {
                return (IStorageController)tileEntity;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.linkedStorageControllerPosition = null;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(StableWormholeBlock.LINKED, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
        return null;
    }

    @Override
    public GlobalBlockPos getLinkedStorageControllerPosition() {
        return this.linkedStorageControllerPosition;
    }

    @Override
    public void setLinkedStorageControllerPosition(GlobalBlockPos blockPos) {
        this.linkedStorageControllerPosition = blockPos;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        IStorageController controller = this.getLinkedStorageController();
        if (controller != null) {
            return ((TileEntity)controller).getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void readNetwork(CompoundNBT compound) {
        if (compound.func_74764_b("linkedStorageControllerPosition")) {
            this.linkedStorageControllerPosition = GlobalBlockPos.from(compound.func_74775_l("linkedStorageControllerPosition"));
        }
        this.setSortDirection(SortDirection.get(compound.func_74762_e("sortDirection")));
        this.setSortType(SortType.get(compound.func_74762_e("sortType")));
        this.matrix = new HashMap<Integer, ItemStack>();
        if (compound.func_74764_b("matrix")) {
            ListNBT matrixNbt = compound.func_150295_c("matrix", 10);
            for (int i = 0; i < matrixNbt.size(); ++i) {
                CompoundNBT stackTag = matrixNbt.func_150305_b(i);
                byte slot = stackTag.func_74771_c("slot");
                ItemStack s = ItemStack.func_199557_a((CompoundNBT)stackTag);
                this.matrix.put(Integer.valueOf(slot), s);
            }
        }
        if (compound.func_74764_b("orderStack")) {
            this.orderStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("orderStack"));
        }
        super.readNetwork(compound);
    }

    @Override
    public CompoundNBT writeNetwork(CompoundNBT compound) {
        if (this.linkedStorageControllerPosition != null) {
            compound.func_218657_a("linkedStorageControllerPosition", (INBT)this.linkedStorageControllerPosition.serializeNBT());
        }
        compound.func_74768_a("sortDirection", this.getSortDirection().getValue());
        compound.func_74768_a("sortType", this.getSortType().getValue());
        ListNBT matrixNbt = new ListNBT();
        for (int i = 0; i < 9; ++i) {
            if (this.matrix.get(i) == null || this.matrix.get(i).func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            stackTag.func_74774_a("slot", (byte)i);
            this.matrix.get(i).func_77955_b(stackTag);
            matrixNbt.add((Object)stackTag);
        }
        compound.func_218657_a("matrix", (INBT)matrixNbt);
        if (!this.orderStack.func_190926_b()) {
            compound.func_218657_a("orderStack", (INBT)this.orderStack.func_77955_b(new CompoundNBT()));
        }
        return super.writeNetwork(compound);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new StableWormholeContainer(id, playerInventory, this);
    }
}

