/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.multichunk;

import com.github.klikli_dev.occultism.common.world.multichunk.IMultiChunkSubFeature;
import com.github.klikli_dev.occultism.common.world.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.util.BiomeUtil;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class MultiChunkFeature
extends Feature<MultiChunkFeatureConfig> {
    public final IMultiChunkSubFeature subFeature;

    public MultiChunkFeature(Codec<MultiChunkFeatureConfig> codec, IMultiChunkSubFeature subFeature) {
        super(codec);
        this.subFeature = subFeature;
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, MultiChunkFeatureConfig config) {
        for (Biome biome : generator.func_202090_b().func_225530_a_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1)) {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
            if (!BiomeUtil.containsType((RegistryKey<Biome>)biomeKey, config.biomeTypeBlacklist)) continue;
            return false;
        }
        ChunkPos generatingChunk = new ChunkPos(pos);
        List<BlockPos> rootPositions = this.getRootPositions(reader, generator, (SharedSeedRandom)rand, generatingChunk, config);
        if (rootPositions.isEmpty()) {
            return false;
        }
        boolean generatedAny = false;
        for (BlockPos rootPosition : rootPositions) {
            if (!this.subFeature.generate(reader, generator, rand, rootPosition, Math3DUtil.bounds(generatingChunk, generator.func_230355_e_()), config)) continue;
            generatedAny = true;
        }
        return generatedAny;
    }

    protected List<BlockPos> getRootPositions(ISeedReader reader, ChunkGenerator generator, SharedSeedRandom random, ChunkPos generatingChunk, MultiChunkFeatureConfig config) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(1);
        for (int i = -config.maxChunksToRoot; i < config.maxChunksToRoot; ++i) {
            for (int j = -config.maxChunksToRoot; j < config.maxChunksToRoot; ++j) {
                ChunkPos currentChunk = new ChunkPos(generatingChunk.field_77276_a + i, generatingChunk.field_77275_b + j);
                random.func_202427_a(reader.func_72905_C(), currentChunk.field_77276_a, currentChunk.field_77275_b, config.featureSeedSalt);
                if (random.nextInt(config.chanceToGenerate) != 0) continue;
                result.add(currentChunk.func_206849_h().func_177982_a(random.nextInt(15), Math.min(generator.func_230355_e_(), config.minGenerationHeight + random.nextInt(Math.max(0, config.maxGenerationHeight - config.minGenerationHeight))), random.nextInt(15)));
            }
        }
        return result;
    }
}

