/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.config;

import com.github.klikli_dev.occultism.config.ConfigBase;
import com.github.klikli_dev.occultism.config.ConfigCategoryBase;
import com.github.klikli_dev.occultism.config.IConfigCache;
import com.github.klikli_dev.occultism.config.value.CachedBoolean;
import com.github.klikli_dev.occultism.config.value.CachedFloat;
import com.github.klikli_dev.occultism.config.value.CachedInt;
import com.github.klikli_dev.occultism.config.value.CachedObject;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class OccultismCommonConfig
extends ConfigBase {
    public final WorldGenSettings worldGen;
    public final ForgeConfigSpec spec;

    public OccultismCommonConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.worldGen = new WorldGenSettings(this, builder);
        this.spec = builder.build();
    }

    public class WorldGenSettings
    extends ConfigCategoryBase {
        public final OreGenSettings oreGen;
        public final UndergroundGroveGenSettings undergroundGroveGen;

        public WorldGenSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("WorldGen Settings").push("worldgen");
            this.oreGen = new OreGenSettings(this, builder);
            this.undergroundGroveGen = new UndergroundGroveGenSettings(this, builder);
            builder.pop();
        }

        public class UndergroundGroveGenSettings
        extends ConfigCategoryBase {
            public final CachedBoolean generateUndergroundGroves;
            public final CachedInt groveSpawnChance;
            public final CachedInt groveSpawnMin;
            public final CachedInt groveSpawnMax;
            public final CachedFloat grassChance;
            public final CachedFloat treeChance;
            public final CachedFloat vineChance;
            public final CachedFloat ceilingLightChance;
            public final CachedObject<List<String>> biomeTypeBlacklist;

            public UndergroundGroveGenSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
                super(parent, builder);
                builder.comment("Underground Grove Settings").push("underground_grove");
                this.generateUndergroundGroves = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("True to generate underground groves. Should not be changed in most scenarios.").define("generateUndergroundGroves", true));
                this.groveSpawnChance = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The chance for a grove to spawn in a chunk (generates 1/groveSpawnChance chunks on average).").define("groveSpawnChance", (Object)400));
                this.groveSpawnMin = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The min height for a grove to spawn (applied to the center of the grove, not the floor).").define("groveSpawnMin", (Object)25));
                this.groveSpawnMax = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max height for a grove to spawn (applied to the center of the grove, not the ceiling).").define("groveSpawnMax", (Object)60));
                this.grassChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance grass will spawn in the underground grove.").define("grassChance", (Object)0.6));
                this.treeChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance small trees will spawn in the underground grove.").define("treeChance", (Object)0.1));
                this.vineChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance vines will spawn in the underground grove.").define("vineChance", (Object)0.3));
                this.ceilingLightChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance glowstone will spawn in the ceiling of the underground grove.").define("ceilingLightChance", (Object)0.1));
                List defaultBiomeTypeBlacklist = Stream.of(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END).map(BiomeDictionary.Type::getName).collect(Collectors.toList());
                this.biomeTypeBlacklist = CachedObject.cache(this, builder.comment("The biome types the underground grove cannot spawn in.").define("biomeTypeBlacklist", defaultBiomeTypeBlacklist));
                builder.pop();
            }
        }

        public class OreGenSettings
        extends ConfigCategoryBase {
            public final OreSettings copperOre;
            public final OreSettings silverOre;
            public final OreSettings iesniumOre;

            public OreGenSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
                super(parent, builder);
                builder.comment("Ore Gen Settings").push("oregen");
                this.copperOre = new OreSettings("copperOre", (ITag<Block>)BlockTags.field_242172_aH, 9, 10, 20, 0, 64, this, builder);
                this.silverOre = new OreSettings("silverOre", (ITag<Block>)BlockTags.field_242172_aH, 7, 3, 5, 0, 30, this, builder);
                this.iesniumOre = new OreSettings("iesniumOre", OccultismTags.NETHERRACK, 3, 10, 10, 10, 128, this, builder);
                builder.pop();
            }

            public class OreSettings
            extends ConfigCategoryBase {
                public final CachedBoolean generateOre;
                public final CachedObject<String> fillerBlockTag;
                public final CachedInt size;
                public final CachedInt count;
                public final CachedInt bottomOffset;
                public final CachedInt topOffset;
                public final CachedInt maximum;

                public OreSettings(String oreName, ITag<Block> fillerBlockTag, int size, int count, int bottomOffset, int topOffset, int maximum, IConfigCache parent, ForgeConfigSpec.Builder builder) {
                    super(parent, builder);
                    builder.comment("Ore Settings").push(oreName);
                    this.generateOre = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("True to generate this ore.").define("generateOre", true));
                    this.fillerBlockTag = CachedObject.cache(this, builder.comment("The tag for the blocks this ore will spawn in.").define("fillerBlockTag", (Object)BlockTags.func_199896_a().func_232973_a_(fillerBlockTag).toString()));
                    this.size = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The size of veins for this ore.").defineInRange("size", size, 0, 127));
                    this.count = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The count value for the decorator for this ore.").defineInRange("count", count, 0, 127));
                    this.bottomOffset = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Range configuration bottom offset.").define("bottomOffset", (Object)bottomOffset));
                    this.topOffset = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Range configuration top offset.").define("topOffset", (Object)topOffset));
                    this.maximum = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Range configuration maximum.").define("maximum", (Object)maximum));
                    builder.pop();
                }

                public ITag<Block> getFillerBlockTag() {
                    return BlockTags.createOptional((ResourceLocation)new ResourceLocation(this.fillerBlockTag.get()));
                }
            }
        }
    }
}

